/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.ui.dialog;

import de.mossgrabers.reaper.AppCallback;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.ui.dialog.BasicDialog;
import de.mossgrabers.reaper.ui.widget.BoxPanel;
import de.mossgrabers.reaper.ui.widget.Functions;
import de.mossgrabers.reaper.ui.widget.TwoColsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DebugDialog
extends BasicDialog {
    private static final long serialVersionUID = 3020319469692178785L;
    private static final String[] LABELS = new String[]{"Transport", "Project", "Track", "Playing Notes", "Device", "Mastertrack", "Browser", "Marker", "Clip", "Session"};
    private static final String[] MNEMONICS = new String[]{"T", "P", "R", "N", "D", "M", "B", "A", "C", "S"};
    private static final Processor[] PROCESSORS = new Processor[]{Processor.TRANSPORT, Processor.PROJECT, Processor.TRACK, Processor.PLAYINGNOTES, Processor.DEVICE, Processor.MASTER, Processor.BROWSER, Processor.MARKER, Processor.CLIP, Processor.SESSION};
    private final transient AppCallback callback;
    private final JCheckBox[] boxes = new JCheckBox[LABELS.length];

    public DebugDialog(Window owner, AppCallback callback) {
        super((JFrame)owner, "Debug", true, true);
        this.callback = callback;
        this.setResizable(false);
        this.setMinimumSize(new Dimension(300, 400));
        this.basicInit();
    }

    @Override
    protected Container init() {
        JPanel contentPane = new JPanel(new BorderLayout());
        TwoColsPanel mainColumn = new TwoColsPanel(true);
        mainColumn.createLabel("Enable data update from:", null, 12);
        for (int i = 0; i < LABELS.length; ++i) {
            int count = i;
            this.boxes[i] = mainColumn.createCheckBox(LABELS[i], MNEMONICS[i], 12);
            this.boxes[i].setSelected(true);
            this.boxes[i].addActionListener(event -> this.callback.enableUpdates(PROCESSORS[count], this.boxes[count].isSelected()));
        }
        contentPane.add((Component)mainColumn, "Center");
        BoxPanel buttons = new BoxPanel(0, true);
        buttons.createSpace(-1);
        this.setButtons(null, buttons.createButton(Functions.getIcon("Confirm"), "Close", null, 0));
        contentPane.add((Component)buttons, "South");
        return contentPane;
    }
}

