/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.ui.dialog;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public abstract class BasicDialog
extends JDialog {
    private static final long serialVersionUID = -1982748939630328892L;
    protected JFrame frame;
    protected boolean confirmed;
    protected JButton ok;
    protected JButton cancel;

    protected BasicDialog(JFrame frame, String title, boolean isModal, boolean disposeOnClose) {
        super(frame, title, isModal);
        this.frame = frame;
        this.setDefaultCloseOperation(disposeOnClose ? 2 : 1);
        this.getRootPane().registerKeyboardAction(e -> this.cancel(), KeyStroke.getKeyStroke(27, 0), 2);
    }

    public void showDialog() {
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void setButtons(JButton ok) {
        this.setButtons(ok, null);
    }

    public void setButtons(JButton ok, JButton cancel) {
        if (ok != null) {
            this.ok = ok;
            ok.addActionListener(new OkButtonActionListener());
            this.getRootPane().setDefaultButton(ok);
        }
        if (cancel != null) {
            this.cancel = cancel;
            cancel.addActionListener(new CancelButtonActionListener());
            if (ok == null) {
                this.getRootPane().setDefaultButton(ok);
            }
        }
    }

    public void setBusy(boolean busy) {
        this.setCursor(Cursor.getPredefinedCursor(busy ? 3 : 0));
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    protected void basicInit() {
        if (this.frame != null) {
            this.frame.setCursor(Cursor.getPredefinedCursor(3));
        }
        this.setEnabled(true);
        this.setContentPane(this.init());
        this.getRootPane().registerKeyboardAction(event -> this.cancel(), KeyStroke.getKeyStroke(27, 0), 2);
        this.set();
        this.pack();
        if (this.frame != null) {
            this.setLocationRelativeTo(this.frame);
        }
        SwingUtilities.updateComponentTreeUI(this);
        if (this.frame != null) {
            this.frame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected abstract Container init();

    protected void set() {
    }

    protected boolean onOk() {
        return true;
    }

    protected boolean onCancel() {
        return true;
    }

    public void ok() {
        this.setBusy(true);
        this.confirmed = true;
        this.processWindowEvent(this.createClosingEvent());
        this.setBusy(false);
    }

    public void cancel() {
        this.setBusy(true);
        this.confirmed = false;
        this.processWindowEvent(this.createClosingEvent());
        this.setBusy(false);
    }

    @Override
    protected void processWindowEvent(WindowEvent event) {
        switch (event.getID()) {
            case 201: {
                if (!(this.confirmed ? !this.onOk() : !this.onCancel())) break;
                return;
            }
            case 200: {
                this.setFocusOn();
                break;
            }
        }
        super.processWindowEvent(event);
    }

    protected void setFocusOn() {
        if (this.ok != null) {
            this.ok.requestFocus();
        }
    }

    private WindowEvent createClosingEvent() {
        return new WindowEvent(this, 201);
    }

    class OkButtonActionListener
    implements ActionListener {
        OkButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicDialog.this.ok();
        }
    }

    class CancelButtonActionListener
    implements ActionListener {
        CancelButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicDialog.this.cancel();
        }
    }
}

