/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.midi;

import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.reaper.communication.BackendExchange;
import de.mossgrabers.reaper.framework.midi.MidiConnection;
import de.mossgrabers.reaper.framework.midi.MidiInputImpl;
import de.mossgrabers.reaper.framework.midi.MidiOutputImpl;
import de.mossgrabers.reaper.framework.midi.ReaperMidiDevice;
import de.mossgrabers.reaper.ui.utils.LogModel;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import javax.sound.midi.MidiDevice;

public class MidiAccessImpl
implements IMidiAccess {
    private static BackendExchange backend;
    private static final Map<String, ReaperMidiDevice> INPUTS;
    private static final Map<String, ReaperMidiDevice> OUTPUTS;
    private final IHost host;
    private final MidiConnection[] midiConnections;
    private final MidiDevice[] inputs;
    private final MidiDevice[] outputs;

    public MidiAccessImpl(LogModel logModel, IHost host, MidiDevice[] inputs, MidiDevice[] outputs) {
        this.host = host;
        this.inputs = inputs;
        this.outputs = outputs;
        int midiConnectionSize = Math.max(inputs.length, outputs.length);
        this.midiConnections = new MidiConnection[midiConnectionSize];
        for (int i = 0; i < midiConnectionSize; ++i) {
            this.midiConnections[i] = new MidiConnection(logModel);
        }
    }

    public static void init(BackendExchange backendExchange) {
        backend = backendExchange;
    }

    public void cleanup() {
        for (MidiConnection midiConnection : this.midiConnections) {
            midiConnection.cleanup();
        }
    }

    @Override
    public IMidiOutput createOutput() {
        return this.createOutput(0);
    }

    @Override
    public IMidiOutput createOutput(int index) {
        this.midiConnections[index].setOutput(this.outputs[index]);
        return new MidiOutputImpl(this.midiConnections[index]);
    }

    @Override
    public IMidiInput createInput(String name, String ... filters) {
        return this.createInput(0, name, filters);
    }

    @Override
    public IMidiInput createInput(int index, String name, String ... filters) {
        return new MidiInputImpl(this.host, backend, this.midiConnections[index], this.inputs[index], filters);
    }

    public static void readDeviceMetadata() {
        INPUTS.clear();
        OUTPUTS.clear();
        TreeMap<String, Integer> keyedNames = new TreeMap<String, Integer>();
        Map<Integer, String> midiInputs = backend.getMidiInputs();
        for (Map.Entry<Integer, String> info : midiInputs.entrySet()) {
            MidiAccessImpl.addDevice(keyedNames, info, true);
        }
        Map<Integer, String> midiOutputs = backend.getMidiOutputs();
        for (Map.Entry<Integer, String> info : midiOutputs.entrySet()) {
            MidiAccessImpl.addDevice(keyedNames, info, false);
        }
    }

    private static void addDevice(Map<String, Integer> keyedNames, Map.Entry<Integer, String> info, boolean isInput) {
        String name = info.getValue();
        String key = (isInput ? "I" : "O") + name;
        Integer count = keyedNames.get(key);
        Integer newCount = count == null ? 1 : count + 1;
        keyedNames.put(key, newCount);
        if (count != null) {
            name = String.format("%s (%d)", name, newCount);
        }
        ReaperMidiDevice device = new ReaperMidiDevice(info.getKey(), name, isInput, backend);
        if (isInput) {
            INPUTS.put(name, device);
        } else {
            OUTPUTS.put(name, device);
        }
    }

    public static Collection<ReaperMidiDevice> getOutputDevices() {
        return OUTPUTS.values();
    }

    public static Collection<ReaperMidiDevice> getInputDevices() {
        return INPUTS.values();
    }

    public static MidiDevice getOutputDevice(String name) {
        return OUTPUTS.get(name);
    }

    public static MidiDevice getInputDevice(String name) {
        return INPUTS.get(name);
    }

    static {
        INPUTS = new TreeMap<String, ReaperMidiDevice>();
        OUTPUTS = new TreeMap<String, ReaperMidiDevice>();
    }
}

