/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.configuration;

import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.reaper.framework.configuration.BaseValueSetting;
import de.mossgrabers.reaper.ui.utils.LogModel;
import de.mossgrabers.reaper.ui.utils.PropertiesEx;
import de.mossgrabers.reaper.ui.utils.SafeRunLater;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class EnumSettingImpl
extends BaseValueSetting<JComboBox<String>, String>
implements IEnumSetting {
    private final String initialValue;
    private String value;

    public EnumSettingImpl(LogModel logModel, PropertiesEx properties, String label, String category, String[] options, String initialValue) {
        super(logModel, label, category, new JComboBox<String>(new DefaultComboBoxModel<String>(options)));
        this.initialValue = initialValue;
        this.load(properties);
        ((JComboBox)this.field).setSelectedItem(this.value);
        ((JComboBox)this.field).addItemListener(event -> SafeRunLater.execute(this.logModel, () -> this.set((String)((JComboBox)this.field).getSelectedItem())));
    }

    @Override
    public void set(String value) {
        this.setInternal(value);
        SafeRunLater.execute(this.logModel, () -> {
            if (this.value != null && !this.value.equals(((JComboBox)this.field).getSelectedItem())) {
                ((JComboBox)this.field).setSelectedItem(this.value);
            }
        });
    }

    private void setInternal(String value) {
        this.value = value;
        this.setDirty();
        this.flush();
    }

    @Override
    public String get() {
        return this.value;
    }

    @Override
    public void flush() {
        this.notifyObservers(this.value);
    }

    @Override
    public void store(PropertiesEx properties) {
        properties.put(this.getID(), this.value);
    }

    @Override
    public void load(PropertiesEx properties) {
        this.set(properties.getString(this.getID(), this.initialValue));
    }

    @Override
    public void setEnabled(boolean enable) {
        ((JComboBox)this.field).setEnabled(enable);
    }

    @Override
    public void reset() {
        this.set(this.initialValue);
    }
}

