/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.daw.resource;

import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.graphics.IImage;
import java.util.HashMap;
import java.util.Map;

public final class ResourceHandler {
    private static final Map<String, IImage> CACHE = new HashMap<String, IImage>();
    private static IHost theHost;

    public static void init(IHost host) {
        theHost = host;
        ResourceHandler.addSVGImage("channel/mute.svg");
        ResourceHandler.addSVGImage("channel/record_arm.svg");
        ResourceHandler.addSVGImage("channel/solo.svg");
        ResourceHandler.addSVGImage("channel/solo.svg");
        ResourceHandler.addSVGImage("track/audio_track.svg");
        ResourceHandler.addSVGImage("track/crossfade_a.svg");
        ResourceHandler.addSVGImage("track/crossfade_ab.svg");
        ResourceHandler.addSVGImage("track/crossfade_b.svg");
        ResourceHandler.addSVGImage("track/group_track.svg");
        ResourceHandler.addSVGImage("track/group_track_open.svg");
        ResourceHandler.addSVGImage("track/hybrid_track.svg");
        ResourceHandler.addSVGImage("track/instrument_track.svg");
        ResourceHandler.addSVGImage("track/master_track.svg");
        ResourceHandler.addSVGImage("track/multi_layer.svg");
        ResourceHandler.addSVGImage("track/return_track.svg");
        ResourceHandler.addSVGImage("device/device_analysis.svg");
        ResourceHandler.addSVGImage("device/device_audio.svg");
        ResourceHandler.addSVGImage("device/device_container.svg");
        ResourceHandler.addSVGImage("device/device_drum_machine.svg");
        ResourceHandler.addSVGImage("device/device_drum_module.svg");
        ResourceHandler.addSVGImage("device/device_generic.svg");
        ResourceHandler.addSVGImage("device/device_instrument.svg");
        ResourceHandler.addSVGImage("device/device_io.svg");
        ResourceHandler.addSVGImage("device/device_note.svg");
        ResourceHandler.addSVGImage("device/device_plugin.svg");
        ResourceHandler.addSVGImage("pin.svg");
        ResourceHandler.addSVGImage("user.svg");
    }

    public static IImage getSVGImage(String imageName) {
        return CACHE.get(imageName);
    }

    public static void addSVGImage(String imageName) {
        CACHE.put(imageName, theHost.loadSVG(imageName, 1));
    }

    private ResourceHandler() {
    }
}

