/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.continuous;

import de.mossgrabers.framework.command.core.AbstractContinuousCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.parameter.IFocusedParameter;
import java.util.Optional;

public class JogWheelCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractContinuousCommand<S, C> {
    private boolean controlLastParamActive = false;
    private final ITransport transport;
    private final IApplication application;
    private final IValueChanger valueChanger;
    private int slowDownCounter = 1;

    public JogWheelCommand(IModel model, S surface) {
        this(model, surface, model.getValueChanger());
    }

    public JogWheelCommand(IModel model, S surface, IValueChanger valueChanger) {
        super(model, surface);
        this.valueChanger = valueChanger;
        this.transport = this.model.getTransport();
        this.application = this.model.getApplication();
    }

    public void toggleControlLastParamActive() {
        this.controlLastParamActive = !this.controlLastParamActive;
    }

    public void setControlLastParamActive(boolean active) {
        this.controlLastParamActive = active;
    }

    public boolean isControlLastParamActive() {
        return this.controlLastParamActive;
    }

    @Override
    public void execute(int value) {
        int encoderKnobSlowDown = this.surface.getConfiguration().getEncoderKnobSlowDown();
        if (encoderKnobSlowDown > 0) {
            if (this.slowDownCounter % (encoderKnobSlowDown + 1) == 0) {
                this.slowDownCounter = 1;
            } else {
                ++this.slowDownCounter;
                return;
            }
        }
        if (this.controlLastParamActive) {
            Optional<IFocusedParameter> parameterOpt = this.model.getFocusedParameter();
            if (parameterOpt.isPresent() && parameterOpt.get().doesExist()) {
                double increment = this.valueChanger.calcKnobChange(value);
                parameterOpt.get().inc(increment *= this.surface.isShiftPressed() ? 10.0 : 50.0);
            }
            return;
        }
        boolean increase = this.valueChanger.isIncrease(value);
        IBrowser browser = this.model.getBrowser();
        if (browser.isActive()) {
            if (increase) {
                browser.selectNextResult();
            } else {
                browser.selectPreviousResult();
            }
            return;
        }
        if (this.surface.isPressed(ButtonID.SELECT)) {
            this.transport.changeTempo(increase, this.surface.isKnobSensitivitySlow());
            return;
        }
        if (this.surface.isPressed(ButtonID.CONTROL)) {
            this.transport.changeLoopStart(increase, this.surface.isKnobSensitivitySlow());
            return;
        }
        if (this.surface.isPressed(ButtonID.ALT)) {
            this.transport.changeLoopLength(increase, this.surface.isKnobSensitivitySlow());
            return;
        }
        if (this.surface.isPressed(ButtonID.ARROW_LEFT) || this.surface.isPressed(ButtonID.ARROW_RIGHT)) {
            this.surface.setTriggerConsumed(ButtonID.ARROW_LEFT);
            this.surface.setTriggerConsumed(ButtonID.ARROW_RIGHT);
            if (increase) {
                this.application.zoomIn();
            } else {
                this.application.zoomOut();
            }
            return;
        }
        if (this.surface.isPressed(ButtonID.ARROW_UP) || this.surface.isPressed(ButtonID.ARROW_DOWN)) {
            this.surface.setTriggerConsumed(ButtonID.ARROW_UP);
            this.surface.setTriggerConsumed(ButtonID.ARROW_DOWN);
            if (increase) {
                this.application.incTrackHeight();
            } else {
                this.application.decTrackHeight();
            }
            return;
        }
        this.transport.changePosition(this.valueChanger.isIncrease(value), this.surface.isKnobSensitivitySlow());
    }
}

