/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.utilities.autocolor;

import de.mossgrabers.controller.utilities.autocolor.AutoColor;
import de.mossgrabers.controller.utilities.autocolor.AutoColorConfiguration;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.valuechanger.TwosComplementValueChanger;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ModelSetup;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.scale.Scales;

public class AutoColorSetup
extends AbstractControllerSetup<IControlSurface<AutoColorConfiguration>, AutoColorConfiguration> {
    private static final int MAX_TRACKS = 100;
    private final AutoColor autoColor;

    public AutoColorSetup(IHost host, ISetupFactory factory, ISettingsUI globalSettings, ISettingsUI documentSettings) {
        super(factory, host, globalSettings, documentSettings);
        this.colorManager = new ColorManager();
        this.valueChanger = new TwosComplementValueChanger(128, 1);
        this.configuration = new AutoColorConfiguration(host, this.valueChanger);
        this.autoColor = new AutoColor((AutoColorConfiguration)this.configuration, host);
    }

    @Override
    public void flush() {
    }

    @Override
    protected void createScales() {
        this.scales = new Scales(this.valueChanger, 0, 128, 128, 1);
        this.scales.setChromatic(true);
    }

    @Override
    protected void createModel() {
        ModelSetup ms = new ModelSetup();
        ms.enableMainDrumDevice(false);
        ms.setNumDeviceLayers(0);
        ms.setNumDevicesInBank(0);
        ms.setNumDrumPadLayers(0);
        ms.setNumFilterColumnEntries(0);
        ms.setNumMarkers(0);
        ms.setNumParamPages(0);
        ms.setNumParams(0);
        ms.setNumResults(0);
        ms.setNumScenes(0);
        ms.setNumSends(0);
        ms.setHasFlatTrackList(true);
        ms.setHasFullFlatTrackList(true);
        ms.setNumTracks(100);
        this.model = this.factory.createModel(this.configuration, this.colorManager, this.valueChanger, this.scales, ms);
        this.autoColor.setTrackBank(this.model.getTrackBank());
    }

    @Override
    protected void createObservers() {
        super.createObservers();
        ((AutoColorConfiguration)this.configuration).addSettingObserver(AutoColorConfiguration.ENABLE_AUTO_COLOR, () -> {
            if (!((AutoColorConfiguration)this.configuration).isEnableAutoColor()) {
                return;
            }
            ITrackBank tb = this.model.getTrackBank();
            for (int i = 0; i < tb.getPageSize(); ++i) {
                this.autoColor.matchTrackName(i, ((ITrack)tb.getItem(i)).getName());
            }
        });
        DAWColor[] colors = DAWColor.values();
        for (int i = 0; i < colors.length; ++i) {
            DAWColor color = colors[i];
            ((AutoColorConfiguration)this.configuration).addSettingObserver(AutoColorConfiguration.COLOR_REGEX + i, () -> this.autoColor.handleRegExChange(color, ((AutoColorConfiguration)this.configuration).getColorRegExValue(color)));
        }
        ITrackBank tb = this.model.getTrackBank();
        for (int index = 0; index < tb.getPageSize(); ++index) {
            int i = index;
            ITrack track = (ITrack)tb.getItem(index);
            track.addNameObserver(name -> this.autoColor.matchTrackName(i, (String)name));
            track.addColorObserver(name -> this.autoColor.matchTrackName(i, track.getName()));
        }
    }

    @Override
    protected void createSurface() {
    }

    @Override
    public void startup() {
    }
}

