/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.jam.view;

import de.mossgrabers.controller.ni.maschine.core.command.trigger.EncoderMode;
import de.mossgrabers.controller.ni.maschine.core.view.IMaschineView;
import de.mossgrabers.controller.ni.maschine.jam.MaschineJamConfiguration;
import de.mossgrabers.controller.ni.maschine.jam.controller.MaschineJamControlSurface;
import de.mossgrabers.controller.ni.maschine.jam.view.IViewNavigation;
import de.mossgrabers.framework.command.trigger.Direction;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractPlayView;

public class PlayView
extends AbstractPlayView<MaschineJamControlSurface, MaschineJamConfiguration>
implements IMaschineView,
IViewNavigation {
    public PlayView(MaschineJamControlSurface surface, IModel model) {
        this("Play", surface, model);
    }

    public PlayView(String name, MaschineJamControlSurface surface, IModel model) {
        super(name, surface, model, true);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (this.isButtonCombination(ButtonID.DELETE)) {
            int editMidiChannel = ((MaschineJamConfiguration)((MaschineJamControlSurface)this.surface).getConfiguration()).getMidiEditChannel();
            this.model.getNoteClip(8, 128).clearRow(editMidiChannel, this.keyManager.map(note));
            return;
        }
        super.onGridNote(note, velocity);
    }

    @Override
    public void changeOption(EncoderMode temporaryEncoderMode, int control) {
        this.keyManager.clearPressedKeys();
        boolean increase = this.model.getValueChanger().isIncrease(control);
        switch (temporaryEncoderMode) {
            case TEMPORARY_PERFORM: {
                if (increase) {
                    this.scales.nextScale();
                } else {
                    this.scales.prevScale();
                }
                this.mvHelper.delayDisplay(() -> "Scale: " + this.scales.getScale().getName());
                break;
            }
            case TEMPORARY_NOTES: {
                if (increase) {
                    this.scales.nextScaleOffset();
                } else {
                    this.scales.prevScaleOffset();
                }
                this.mvHelper.delayDisplay(() -> "Scale Offset: " + Scales.BASES.get(this.scales.getScaleOffsetIndex()));
                break;
            }
            case TEMPORARY_LOCK: {
                this.scales.toggleChromatic();
                this.mvHelper.delayDisplay(() -> "Chromatic: " + (this.scales.isChromatic() ? "On" : "Off"));
                break;
            }
            case TEMPORARY_TUNE: {
                if (increase) {
                    this.scales.incOctave();
                } else {
                    this.scales.decOctave();
                }
                this.mvHelper.delayDisplay(() -> "Octave: " + this.scales.getOctave());
                break;
            }
        }
        this.updateScale();
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        switch (buttonID) {
            case ARROW_LEFT: 
            case ARROW_RIGHT: {
                if (buttonID == ButtonID.ARROW_LEFT) {
                    this.scales.prevScaleLayout();
                } else {
                    this.scales.nextScaleLayout();
                }
                this.updateScale();
                this.mvHelper.delayDisplay(() -> "Scale Layout: " + this.scales.getScaleLayout().getName());
                break;
            }
            case ARROW_UP: {
                this.onOctaveUp(event);
                break;
            }
            case ARROW_DOWN: {
                this.onOctaveDown(event);
                break;
            }
            default: {
                super.onButton(buttonID, event, velocity);
            }
        }
    }

    @Override
    public boolean canScroll(Direction direction) {
        switch (direction) {
            case LEFT: {
                return this.scales.hasPrevScaleLayout();
            }
            case RIGHT: {
                return this.scales.hasNextScaleLayout();
            }
            case UP: {
                return this.isOctaveUpButtonOn();
            }
            case DOWN: {
                return this.isOctaveDownButtonOn();
            }
        }
        return false;
    }

    @Override
    public boolean wasAlternateInteractionUsed() {
        return false;
    }

    @Override
    public void setAlternateInteractionUsed(boolean wasUsed) {
    }
}

