/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mki.view;

import de.mossgrabers.controller.ni.kontrol.mki.Kontrol1Configuration;
import de.mossgrabers.controller.ni.kontrol.mki.controller.Kontrol1ControlSurface;
import de.mossgrabers.framework.controller.grid.ILightGuide;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.data.IDrumDevice;
import de.mossgrabers.framework.daw.data.IDrumPad;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.view.AbstractPlayView;

public class ControlView
extends AbstractPlayView<Kontrol1ControlSurface, Kontrol1Configuration> {
    public ControlView(Kontrol1ControlSurface surface, IModel model) {
        super(surface, model, true);
    }

    @Override
    public void updateNoteMapping() {
        boolean isActive = ((Kontrol1Configuration)((Kontrol1ControlSurface)this.surface).getConfiguration()).isScaleIsActive();
        int[] matrix = isActive && this.model.canSelectedTrackHoldNotes() ? Scales.getIdentityMatrix() : EMPTY_TABLE;
        ((Kontrol1ControlSurface)this.surface).scheduleTask(() -> this.keyManager.setNoteMatrix(matrix), 6L);
    }

    @Override
    public void drawGrid() {
        IDrumDevice primary;
        ILightGuide lightGuide = ((Kontrol1ControlSurface)this.surface).getLightGuide();
        if (this.model.getHost().supports(Capability.HAS_DRUM_DEVICE) && this.model.canSelectedTrackHoldNotes() && (primary = this.model.getDrumDevice()).hasDrumPads()) {
            boolean isRecording = this.model.hasRecordingState();
            for (int i = this.scales.getStartNote(); i < this.scales.getEndNote(); ++i) {
                lightGuide.light(i, this.getDrumPadColor(i, primary, isRecording));
            }
            return;
        }
        this.drawLightGuide(lightGuide);
    }

    protected String getDrumPadColor(int index, IDrumDevice primary, boolean isRecording) {
        int midiNote = this.keyManager.map(index);
        if (midiNote == -1) {
            return "SCALE_COLOR_OFF";
        }
        if (this.keyManager.isKeyPressed(index)) {
            return isRecording ? "COLOR_PAD_RECORD" : "COLOR_PAD_PLAY";
        }
        IDrumPadBank drumPadBank = primary.getDrumPadBank();
        IDrumPad drumPad = drumPadBank.getItem(index);
        if (!drumPad.doesExist() || !drumPad.isActivated()) {
            return ((Kontrol1Configuration)((Kontrol1ControlSurface)this.surface).getConfiguration()).isTurnOffEmptyDrumPads() ? "COLOR_PAD_OFF" : "COLOR_PAD_NO_CONTENT";
        }
        if (drumPad.isMute() || drumPadBank.hasSoloedPads() && !drumPad.isSolo()) {
            return "COLOR_PAD_MUTED";
        }
        return DAWColor.getColorID(drumPad.getColor());
    }

    @Override
    public void onGridNote(int note, int velocity) {
    }
}

