/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.controller.generic.controller.GenericFlexiControlSurface;
import de.mossgrabers.controller.generic.flexihandler.AbstractHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.FlexiHandlerException;
import de.mossgrabers.controller.generic.flexihandler.utils.KnobMode;
import de.mossgrabers.controller.generic.flexihandler.utils.MidiValue;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.parameter.IParameter;

public class ProjectRemotesHandler
extends AbstractHandler {
    public ProjectRemotesHandler(IModel model, GenericFlexiControlSurface surface, GenericFlexiConfiguration configuration, IValueChanger absoluteLowResValueChanger, IValueChanger signedBitRelativeValueChanger, IValueChanger signedBit2RelativeValueChanger, IValueChanger offsetBinaryRelativeValueChanger) {
        super(model, surface, configuration, absoluteLowResValueChanger, signedBitRelativeValueChanger, signedBit2RelativeValueChanger, offsetBinaryRelativeValueChanger);
    }

    @Override
    public FlexiCommand[] getSupportedCommands() {
        return new FlexiCommand[]{FlexiCommand.PROJECT_SET_PARAMETER_1, FlexiCommand.PROJECT_SET_PARAMETER_2, FlexiCommand.PROJECT_SET_PARAMETER_3, FlexiCommand.PROJECT_SET_PARAMETER_4, FlexiCommand.PROJECT_SET_PARAMETER_5, FlexiCommand.PROJECT_SET_PARAMETER_6, FlexiCommand.PROJECT_SET_PARAMETER_7, FlexiCommand.PROJECT_SET_PARAMETER_8, FlexiCommand.PROJECT_SELECT_PREVIOUS_PAGE, FlexiCommand.PROJECT_SELECT_NEXT_PAGE, FlexiCommand.PROJECT_SELECT_PARAMETER_PAGE_1, FlexiCommand.PROJECT_SELECT_PARAMETER_PAGE_2, FlexiCommand.PROJECT_SELECT_PARAMETER_PAGE_3, FlexiCommand.PROJECT_SELECT_PARAMETER_PAGE_4, FlexiCommand.PROJECT_SELECT_PARAMETER_PAGE_5, FlexiCommand.PROJECT_SELECT_PARAMETER_PAGE_6, FlexiCommand.PROJECT_SELECT_PARAMETER_PAGE_7, FlexiCommand.PROJECT_SELECT_PARAMETER_PAGE_8, FlexiCommand.PROJECT_SCROLL_PARAMETER_PAGES, FlexiCommand.PROJECT_SELECT_PREVIOUS_PARAMETER_BANK, FlexiCommand.PROJECT_SELECT_NEXT_PARAMETER_BANK, FlexiCommand.PROJECT_SCROLL_PARAMETER_BANKS, FlexiCommand.PROJECT_TOGGLE_PARAMETER_1, FlexiCommand.PROJECT_TOGGLE_PARAMETER_2, FlexiCommand.PROJECT_TOGGLE_PARAMETER_3, FlexiCommand.PROJECT_TOGGLE_PARAMETER_4, FlexiCommand.PROJECT_TOGGLE_PARAMETER_5, FlexiCommand.PROJECT_TOGGLE_PARAMETER_6, FlexiCommand.PROJECT_TOGGLE_PARAMETER_7, FlexiCommand.PROJECT_TOGGLE_PARAMETER_8, FlexiCommand.PROJECT_RESET_PARAMETER_1, FlexiCommand.PROJECT_RESET_PARAMETER_2, FlexiCommand.PROJECT_RESET_PARAMETER_3, FlexiCommand.PROJECT_RESET_PARAMETER_4, FlexiCommand.PROJECT_RESET_PARAMETER_5, FlexiCommand.PROJECT_RESET_PARAMETER_6, FlexiCommand.PROJECT_RESET_PARAMETER_7, FlexiCommand.PROJECT_RESET_PARAMETER_8};
    }

    @Override
    public int getCommandValue(FlexiCommand command) {
        IParameterBank projectParameterBank = this.model.getProject().getParameterBank();
        if (projectParameterBank == null) {
            return -1;
        }
        switch (command) {
            case PROJECT_SET_PARAMETER_1: 
            case PROJECT_SET_PARAMETER_2: 
            case PROJECT_SET_PARAMETER_3: 
            case PROJECT_SET_PARAMETER_4: 
            case PROJECT_SET_PARAMETER_5: 
            case PROJECT_SET_PARAMETER_6: 
            case PROJECT_SET_PARAMETER_7: 
            case PROJECT_SET_PARAMETER_8: {
                return ((IParameter)projectParameterBank.getItem(command.ordinal() - FlexiCommand.PROJECT_SET_PARAMETER_1.ordinal())).getValue();
            }
            case PROJECT_TOGGLE_PARAMETER_1: 
            case PROJECT_TOGGLE_PARAMETER_2: 
            case PROJECT_TOGGLE_PARAMETER_3: 
            case PROJECT_TOGGLE_PARAMETER_4: 
            case PROJECT_TOGGLE_PARAMETER_5: 
            case PROJECT_TOGGLE_PARAMETER_6: 
            case PROJECT_TOGGLE_PARAMETER_7: 
            case PROJECT_TOGGLE_PARAMETER_8: {
                int value = ((IParameter)projectParameterBank.getItem(command.ordinal() - FlexiCommand.PROJECT_TOGGLE_PARAMETER_1.ordinal())).getValue();
                return ProjectRemotesHandler.toMidiValue(value > 0);
            }
            case PROJECT_SELECT_PARAMETER_PAGE_1: 
            case PROJECT_SELECT_PARAMETER_PAGE_2: 
            case PROJECT_SELECT_PARAMETER_PAGE_3: 
            case PROJECT_SELECT_PARAMETER_PAGE_4: 
            case PROJECT_SELECT_PARAMETER_PAGE_5: 
            case PROJECT_SELECT_PARAMETER_PAGE_6: 
            case PROJECT_SELECT_PARAMETER_PAGE_7: 
            case PROJECT_SELECT_PARAMETER_PAGE_8: {
                return ((IParameter)projectParameterBank.getItem(command.ordinal() - FlexiCommand.PROJECT_SELECT_PARAMETER_PAGE_1.ordinal())).isSelected() ? 127 : 0;
            }
        }
        return -1;
    }

    @Override
    public void handle(FlexiCommand command, KnobMode knobMode, MidiValue value) {
        IParameterBank projectParameterBank = this.model.getProject().getParameterBank();
        if (projectParameterBank == null) {
            return;
        }
        switch (command) {
            case PROJECT_SET_PARAMETER_1: 
            case PROJECT_SET_PARAMETER_2: 
            case PROJECT_SET_PARAMETER_3: 
            case PROJECT_SET_PARAMETER_4: 
            case PROJECT_SET_PARAMETER_5: 
            case PROJECT_SET_PARAMETER_6: 
            case PROJECT_SET_PARAMETER_7: 
            case PROJECT_SET_PARAMETER_8: {
                IParameter projectParam = (IParameter)projectParameterBank.getItem(command.ordinal() - FlexiCommand.PROJECT_SET_PARAMETER_1.ordinal());
                int val = value.getValue();
                if (ProjectRemotesHandler.isAbsolute(knobMode)) {
                    projectParam.setValue(this.getAbsoluteValueChanger(value), val);
                    break;
                }
                projectParam.changeValue(this.getRelativeValueChanger(knobMode), val);
                break;
            }
            case PROJECT_RESET_PARAMETER_1: 
            case PROJECT_RESET_PARAMETER_2: 
            case PROJECT_RESET_PARAMETER_3: 
            case PROJECT_RESET_PARAMETER_4: 
            case PROJECT_RESET_PARAMETER_5: 
            case PROJECT_RESET_PARAMETER_6: 
            case PROJECT_RESET_PARAMETER_7: 
            case PROJECT_RESET_PARAMETER_8: {
                if (!this.isButtonPressed(knobMode, value)) break;
                ((IParameter)projectParameterBank.getItem(command.ordinal() - FlexiCommand.PROJECT_RESET_PARAMETER_1.ordinal())).resetValue();
                break;
            }
            case PROJECT_TOGGLE_PARAMETER_1: 
            case PROJECT_TOGGLE_PARAMETER_2: 
            case PROJECT_TOGGLE_PARAMETER_3: 
            case PROJECT_TOGGLE_PARAMETER_4: 
            case PROJECT_TOGGLE_PARAMETER_5: 
            case PROJECT_TOGGLE_PARAMETER_6: 
            case PROJECT_TOGGLE_PARAMETER_7: 
            case PROJECT_TOGGLE_PARAMETER_8: {
                IParameter projectToggleParam = (IParameter)projectParameterBank.getItem(command.ordinal() - FlexiCommand.PROJECT_TOGGLE_PARAMETER_1.ordinal());
                if (!this.isButtonPressed(knobMode, value)) break;
                int v = projectToggleParam.getValue();
                projectToggleParam.setValue(v > 0 ? 0 : this.model.getValueChanger().getUpperBound() - 1);
                break;
            }
            case PROJECT_SELECT_PREVIOUS_PAGE: {
                if (!this.isButtonPressed(knobMode, value)) break;
                projectParameterBank.scrollBackwards();
                this.mvHelper.notifySelectedProjectParameterPage();
                break;
            }
            case PROJECT_SELECT_NEXT_PAGE: {
                if (!this.isButtonPressed(knobMode, value)) break;
                projectParameterBank.scrollForwards();
                this.mvHelper.notifySelectedProjectParameterPage();
                break;
            }
            case PROJECT_SELECT_PARAMETER_PAGE_1: 
            case PROJECT_SELECT_PARAMETER_PAGE_2: 
            case PROJECT_SELECT_PARAMETER_PAGE_3: 
            case PROJECT_SELECT_PARAMETER_PAGE_4: 
            case PROJECT_SELECT_PARAMETER_PAGE_5: 
            case PROJECT_SELECT_PARAMETER_PAGE_6: 
            case PROJECT_SELECT_PARAMETER_PAGE_7: 
            case PROJECT_SELECT_PARAMETER_PAGE_8: {
                if (!this.isButtonPressed(knobMode, value)) break;
                projectParameterBank.getPageBank().selectPage(command.ordinal() - FlexiCommand.PROJECT_SELECT_PARAMETER_PAGE_1.ordinal());
                this.mvHelper.notifySelectedDeviceAndParameterPage();
                break;
            }
            case PROJECT_SCROLL_PARAMETER_PAGES: {
                this.scrollParameterPage(knobMode, value);
                break;
            }
            case PROJECT_SELECT_PREVIOUS_PARAMETER_BANK: {
                if (!this.isButtonPressed(knobMode, value)) break;
                projectParameterBank.selectPreviousPage();
                break;
            }
            case PROJECT_SELECT_NEXT_PARAMETER_BANK: {
                if (!this.isButtonPressed(knobMode, value)) break;
                projectParameterBank.selectNextPage();
                break;
            }
            case PROJECT_SCROLL_PARAMETER_BANKS: {
                this.scrollParameterBank(knobMode, value);
                break;
            }
            default: {
                throw new FlexiHandlerException(command);
            }
        }
    }

    private void scrollParameterPage(KnobMode knobMode, MidiValue value) {
        if (ProjectRemotesHandler.isAbsolute(knobMode) || !this.increaseKnobMovement()) {
            return;
        }
        IParameterBank projectParameterBank = this.model.getProject().getParameterBank();
        if (this.isIncrease(knobMode, value)) {
            projectParameterBank.scrollForwards();
        } else {
            projectParameterBank.scrollBackwards();
        }
        this.mvHelper.notifySelectedParameterPage();
    }

    private void scrollParameterBank(KnobMode knobMode, MidiValue value) {
        if (ProjectRemotesHandler.isAbsolute(knobMode) || !this.increaseKnobMovement()) {
            return;
        }
        IParameterBank projectParameterBank = this.model.getProject().getParameterBank();
        if (this.isIncrease(knobMode, value)) {
            projectParameterBank.selectNextPage();
        } else {
            projectParameterBank.selectPreviousPage();
        }
        this.mvHelper.notifySelectedParameterPage();
    }
}

