/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.device;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.Push1Display;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.controller.ableton.push.mode.device.DeviceParamsMode;
import de.mossgrabers.controller.ableton.push.parameterprovider.PushSelectedLayerOrDrumPadParameterProvider;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.bank.ILayerBank;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.graphics.canvas.utils.SendData;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.Pair;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class DeviceLayerMode
extends BaseMode<ILayer> {
    protected final List<Pair<String, Boolean>> menu = new ArrayList<Pair<String, Boolean>>();
    protected final ICursorDevice cursorDevice;
    protected final PushConfiguration configuration = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();

    public DeviceLayerMode(PushControlSurface surface, IModel model) {
        this("Layer", surface, model);
        this.setParameterProvider(new PushSelectedLayerOrDrumPadParameterProvider(this.cursorDevice, this.configuration));
    }

    DeviceLayerMode(String name, PushControlSurface surface, IModel model) {
        super(name, surface, model, model.getCursorDevice().getLayerBank());
        this.cursorDevice = this.model.getCursorDevice();
        this.cursorDevice.addHasDrumPadsObserver(hasDrumPads -> this.switchBanks(this.cursorDevice.hasDrumPads() ? this.cursorDevice.getDrumPadBank() : this.cursorDevice.getLayerBank()));
        for (int i = 0; i < 8; ++i) {
            this.menu.add(new Pair<String, Boolean>(" ", Boolean.FALSE));
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        IParameter iParameter;
        Optional channelOpt = this.bank.getSelectedItem();
        if (channelOpt.isEmpty()) {
            return;
        }
        ILayer channel = (ILayer)channelOpt.get();
        this.setTouchedKnob(index, isTouched);
        ISendBank sendBank = channel.getSendBank();
        if (isTouched && ((PushControlSurface)this.surface).isDeletePressed()) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
            switch (index) {
                case 0: {
                    channel.resetVolume();
                    break;
                }
                case 1: {
                    channel.resetPan();
                    break;
                }
                default: {
                    if (this.isPushModern && index < 4) break;
                    ((ISend)sendBank.getItem(this.getSendIndex(index))).resetValue();
                }
            }
            return;
        }
        switch (index) {
            case 0: {
                channel.touchVolume(isTouched);
                break;
            }
            case 1: {
                channel.touchPan(isTouched);
                break;
            }
            default: {
                if (this.isPushModern && index < 4) break;
                ((ISend)sendBank.getItem(this.getSendIndex(index))).touchValue(isTouched);
            }
        }
        this.checkStopAutomationOnKnobRelease(isTouched);
        if (isTouched && ((PushControlSurface)this.surface).isShiftPressed() && ((PushControlSurface)this.surface).isSelectPressed() && (iParameter = this.getParameterProvider().get(index)) instanceof ISend) {
            ISend send = (ISend)iParameter;
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.SELECT);
            send.toggleEnabled();
        }
    }

    private int getSendIndex(int index) {
        return this.isPushModern ? index - 4 : index - 2;
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            return;
        }
        if (event == ButtonEvent.UP) {
            if (!this.cursorDevice.doesExist()) {
                return;
            }
            int offset = this.getDrumPadIndex();
            ILayer layer = (ILayer)this.bank.getItem(offset + index);
            if (!layer.doesExist()) {
                return;
            }
            int layerIndex = layer.getIndex();
            if (!layer.isSelected()) {
                ((ILayer)this.bank.getItem(layerIndex)).select();
                return;
            }
            if (!layer.hasDevices()) {
                return;
            }
            layer.enter();
            ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
            this.setMode(Modes.DEVICE_PARAMS);
            ((DeviceParamsMode)modeManager.get(Modes.DEVICE_PARAMS)).setShowDevices(true);
            return;
        }
        ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.get(ButtonID.ROW1_1, index));
        this.moveUp();
    }

    protected void moveUp() {
        if (!this.cursorDevice.doesExist()) {
            ((PushControlSurface)this.surface).getButton(ButtonID.TRACK).trigger(ButtonEvent.DOWN);
            return;
        }
        this.setMode(Modes.DEVICE_PARAMS);
        this.cursorDevice.selectChannel();
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        ((DeviceParamsMode)modeManager.get(Modes.DEVICE_PARAMS)).setShowDevices(true);
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (this.configuration.isMuteState(((PushControlSurface)this.surface).isLongPressed(ButtonID.MUTE))) {
            ((ILayer)this.bank.getItem(this.getDrumPadIndex() + index)).toggleMute();
            return;
        }
        if (this.configuration.isSoloState(((PushControlSurface)this.surface).isLongPressed(ButtonID.SOLO))) {
            ((ILayer)this.bank.getItem(this.getDrumPadIndex() + index)).toggleSolo();
            return;
        }
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        switch (index) {
            case 0: {
                if (modeManager.isActive(new Modes[]{Modes.DEVICE_LAYER_VOLUME})) {
                    this.setMode(Modes.DEVICE_LAYER);
                    break;
                }
                this.setMode(Modes.DEVICE_LAYER_VOLUME);
                break;
            }
            case 1: {
                if (modeManager.isActive(new Modes[]{Modes.DEVICE_LAYER_PAN})) {
                    this.setMode(Modes.DEVICE_LAYER);
                    break;
                }
                this.setMode(Modes.DEVICE_LAYER_PAN);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                boolean isShift = ((PushControlSurface)this.surface).isShiftPressed();
                int offset = this.getDrumPadIndex();
                for (int i = 0; i < this.bank.getPageSize(); ++i) {
                    ILayer layer = (ILayer)this.bank.getItem(offset + i);
                    ISendBank sendBank = layer.getSendBank();
                    if (isShift) {
                        if (sendBank.canScrollPageBackwards()) {
                            sendBank.selectPreviousPage();
                            continue;
                        }
                        sendBank.scrollTo(sendBank.getItemCount() / 4 * 4);
                        continue;
                    }
                    if (sendBank.canScrollPageForwards()) {
                        sendBank.selectNextPage();
                        continue;
                    }
                    sendBank.scrollTo(0);
                }
                break;
            }
            case 7: {
                if (((PushControlSurface)this.surface).isShiftPressed()) {
                    this.handleSendEffect(3);
                    break;
                }
                this.moveUp();
                break;
            }
            default: {
                this.handleSendEffect(index - 4);
            }
        }
    }

    private void setMode(Modes layerMode) {
        ((PushControlSurface)this.surface).getModeManager().setActive(layerMode);
        if (Modes.isLayerMode(layerMode)) {
            ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).setLayerMixMode(layerMode);
        }
    }

    protected void handleSendEffect(int sendIndex) {
        ISendBank sendBank = ((ILayer)this.bank.getItem(0)).getSendBank();
        if (!((ISend)sendBank.getItem(sendIndex)).doesExist()) {
            return;
        }
        Modes si = Modes.get(Modes.DEVICE_LAYER_SEND1, sendIndex);
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        this.setMode(modeManager.isActive(new Modes[]{si}) ? Modes.DEVICE_LAYER : si);
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        if (!this.cursorDevice.doesExist()) {
            display.setBlock(1, 0, "           Select").setBlock(1, 1, "a device or press").setBlock(1, 2, "'Add Effect'...  ").allDone();
            return;
        }
        if (!this.cursorDevice.hasLayers()) {
            display.setBlock(1, 1, "    This device  ").setBlock(1, 2, "does not have layers.");
        } else if (!this.bank.hasExistingItems()) {
            display.setBlock(1, 1, "    Please create").setBlock(1, 2, this.cursorDevice.hasDrumPads() ? "a Drum Pad..." : "a Device Layer...");
        } else {
            Optional layer = this.bank.getSelectedItem();
            if (layer.isPresent()) {
                ILayer l = (ILayer)layer.get();
                display.setCell(0, 0, "Volume").setCell(1, 0, l.getVolumeStr(8)).setCell(2, 0, this.configuration.isEnableVUMeters() ? l.getVu() : l.getVolume(), Format.FORMAT_VALUE);
                display.setCell(0, 1, "Pan").setCell(1, 1, l.getPanStr(8)).setCell(2, 1, l.getPan(), Format.FORMAT_PAN);
                ISendBank sendBank = l.getSendBank();
                for (int i = 0; i < 6; ++i) {
                    int pos = 2 + i;
                    ISend send = (ISend)sendBank.getItem(i);
                    display.setCell(0, pos, send.getName()).setCell(1, pos, send.getDisplayedValue(8)).setCell(2, pos, send.getValue(), Format.FORMAT_VALUE);
                }
            }
        }
        this.drawRow4(display);
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        if (!this.cursorDevice.doesExist()) {
            for (int i = 0; i < 8; ++i) {
                display.addOptionElement(i == 2 ? "Please select a device or press 'Add Device'..." : "", i == 7 ? "Up" : "", true, "", "", false, true);
            }
            return;
        }
        if (this.checkLayerExistance(display)) {
            this.updateDisplayElements(display, this.bank.getSelectedItem());
        }
    }

    protected boolean checkLayerExistance(IGraphicDisplay display) {
        if (!this.cursorDevice.hasLayers()) {
            for (int i = 0; i < 8; ++i) {
                display.addOptionElement(i == 3 ? "This device does not have layers." : "", i == 7 ? "Up" : "", true, "", "", false, true);
            }
            return false;
        }
        if (this.bank.hasExistingItems()) {
            return true;
        }
        for (int i = 0; i < 8; ++i) {
            Object label = i == 3 ? "Please create a " + (this.cursorDevice.hasDrumPads() ? "Drum Pad..." : "Device Layer...") : "";
            display.addOptionElement((String)label, i == 7 ? "Up" : "", true, "", "", false, true);
        }
        return false;
    }

    protected void updateDisplayElements(IGraphicDisplay display, Optional<ILayer> l) {
        int sendsIndex;
        int offset = this.getDrumPadIndex();
        int n = sendsIndex = l.isEmpty() ? -1 : l.get().getIndex() - offset + 1;
        if (sendsIndex == 8) {
            sendsIndex = 6;
        }
        this.updateMenuItems(-1);
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        for (int i = 0; i < 8; ++i) {
            IChannel layer = (IChannel)this.bank.getItem(offset + i);
            Pair<String, Boolean> pair = this.menu.get(i);
            String topMenu = pair.getKey();
            boolean isTopMenuOn = pair.getValue();
            String bottomMenu = layer.doesExist() ? layer.getName(12) : "";
            ColorEx bottomMenuColor = layer.getColor();
            boolean isBottomMenuOn = layer.isSelected();
            if (layer.isSelected()) {
                IValueChanger valueChanger = this.model.getValueChanger();
                boolean enableVUMeters = config.isEnableVUMeters();
                int vuR = valueChanger.toDisplayValue(enableVUMeters ? layer.getVuRight() : 0);
                int vuL = valueChanger.toDisplayValue(enableVUMeters ? layer.getVuLeft() : 0);
                display.addChannelElement(topMenu, isTopMenuOn, bottomMenu, ChannelType.LAYER, bottomMenuColor, isBottomMenuOn, valueChanger.toDisplayValue(layer.getVolume()), valueChanger.toDisplayValue(layer.getModulatedVolume()), this.isKnobTouched(0) ? layer.getVolumeStr(8) : "", valueChanger.toDisplayValue(layer.getPan()), valueChanger.toDisplayValue(layer.getModulatedPan()), this.isKnobTouched(1) ? layer.getPanStr(8) : "", vuL, vuR, layer.isMute(), layer.isSolo(), false, layer.isActivated(), 0, false);
                continue;
            }
            if (sendsIndex == i && l.isPresent()) {
                ISendBank sendBank = l.get().getSendBank();
                SendData[] sendData = new SendData[4];
                for (int j = 0; j < 4; ++j) {
                    ISend send = (ISend)sendBank.getItem(j);
                    boolean doesExist = send.doesExist();
                    sendData[j] = new SendData(send.isEnabled(), send.getName(), doesExist && this.isKnobTouched(4 + j) ? send.getDisplayedValue() : "", doesExist ? send.getValue() : 0, doesExist ? send.getModulatedValue() : 0, true);
                }
                display.addSendsElement(topMenu, isTopMenuOn, layer.doesExist() ? layer.getName() : "", ChannelType.LAYER, ((ILayer)this.bank.getItem(offset + i)).getColor(), layer.isSelected(), sendData, true, l.get().isActivated(), layer.isActivated());
                continue;
            }
            display.addChannelSelectorElement(topMenu, isTopMenuOn, bottomMenu, ChannelType.LAYER, bottomMenuColor, isBottomMenuOn, layer.isActivated());
        }
    }

    protected void updateChannelDisplay(IGraphicDisplay display, int selectedMenu, boolean isVolume, boolean isPan) {
        this.updateMenuItems(selectedMenu);
        int offset = this.getDrumPadIndex();
        IValueChanger valueChanger = this.model.getValueChanger();
        for (int i = 0; i < 8; ++i) {
            IChannel layer = (IChannel)this.bank.getItem(offset + i);
            Pair<String, Boolean> pair = this.menu.get(i);
            String topMenu = pair.getKey();
            boolean isTopMenuOn = pair.getValue();
            boolean enableVUMeters = this.configuration.isEnableVUMeters();
            int vuR = valueChanger.toDisplayValue(enableVUMeters ? layer.getVuRight() : 0);
            int vuL = valueChanger.toDisplayValue(enableVUMeters ? layer.getVuLeft() : 0);
            display.addChannelElement(selectedMenu, topMenu, isTopMenuOn, layer.doesExist() ? layer.getName() : "", ChannelType.LAYER, layer.getColor(), layer.isSelected(), valueChanger.toDisplayValue(layer.getVolume()), valueChanger.toDisplayValue(layer.getModulatedVolume()), isVolume && this.isKnobTouched(i) ? layer.getVolumeStr(8) : "", valueChanger.toDisplayValue(layer.getPan()), valueChanger.toDisplayValue(layer.getModulatedPan()), isPan && this.isKnobTouched(i) ? layer.getPanStr() : "", vuL, vuR, layer.isMute(), layer.isSolo(), false, layer.isActivated(), 0, false);
        }
    }

    protected void updateMenuItems(int selectedMenu) {
        if (this.configuration.isMuteState(((PushControlSurface)this.surface).isLongPressed(ButtonID.MUTE))) {
            this.updateMuteMenu();
        } else if (this.configuration.isSoloState(((PushControlSurface)this.surface).isLongPressed(ButtonID.SOLO))) {
            this.updateSoloMenu();
        } else {
            this.updateLayerMenu(selectedMenu);
        }
    }

    protected void updateSoloMenu() {
        for (int i = 0; i < 8; ++i) {
            IChannel layer;
            this.menu.get(i).set((layer = (IChannel)this.bank.getItem(i)).doesExist() ? "Solo" : "", layer.isSolo());
        }
    }

    protected void updateMuteMenu() {
        for (int i = 0; i < 8; ++i) {
            IChannel layer;
            this.menu.get(i).set((layer = (IChannel)this.bank.getItem(i)).doesExist() ? "Mute" : "", layer.isMute());
        }
    }

    protected void updateLayerMenu(int selectedMenu) {
        this.menu.get(0).set("Volume", selectedMenu - 1 == 0);
        this.menu.get(1).set("Pan", selectedMenu - 1 == 1);
        this.menu.get(2).set(" ", Boolean.FALSE);
        ILayerBank layerBank = (ILayerBank)this.bank;
        int start = Math.max(0, ((ISend)((ILayer)layerBank.getItem(0)).getSendBank().getItem(0)).getPosition()) + 1;
        this.menu.get(3).set(String.format("Sends %d-%d", start, start + 3), Boolean.FALSE);
        for (int i = 0; i < 4; ++i) {
            String sendName;
            this.menu.get(4 + i).set((sendName = StringUtils.optimizeName(layerBank.getEditSendName(i), 12)).isEmpty() ? " " : sendName, 4 + i == selectedMenu - 1);
        }
        if (!((PushControlSurface)this.surface).isShiftPressed() && !this.isKnobTouched(7)) {
            this.menu.get(7).set("Up", Boolean.TRUE);
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        ICursorDevice cd = this.model.getCursorDevice();
        if (cd == null || !cd.hasLayers()) {
            return super.getButtonColor(buttonID);
        }
        int offset = this.getDrumPadIndex();
        int index = this.isButtonRow(0, buttonID);
        if (index >= 0) {
            IChannel dl = (IChannel)this.bank.getItem(offset + buttonID.ordinal() - ButtonID.ROW1_1.ordinal());
            if (dl.doesExist() && dl.isActivated()) {
                if (dl.isSelected()) {
                    return this.isPushModern ? 9 : 10;
                }
                return this.isPushModern ? 15 : 13;
            }
            return super.getButtonColor(buttonID);
        }
        index = this.isButtonRow(1, buttonID);
        if (index >= 0) {
            IChannel layer = (IChannel)this.bank.getItem(offset + index);
            if (this.isPushModern) {
                boolean isMuteState = this.configuration.isMuteState(((PushControlSurface)this.surface).isLongPressed(ButtonID.MUTE));
                if (isMuteState || this.configuration.isSoloState(((PushControlSurface)this.surface).isLongPressed(ButtonID.SOLO))) {
                    if (layer.doesExist()) {
                        if (isMuteState) {
                            if (layer.isMute()) {
                                return 11;
                            }
                        } else if (layer.isSolo()) {
                            return 13;
                        }
                    }
                    return 0;
                }
                ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
                switch (index) {
                    case 0: {
                        return modeManager.isActive(new Modes[]{Modes.DEVICE_LAYER_VOLUME}) ? 3 : 0;
                    }
                    case 1: {
                        return modeManager.isActive(new Modes[]{Modes.DEVICE_LAYER_PAN}) ? 3 : 0;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return modeManager.isActive(new Modes[]{Modes.get(Modes.DEVICE_LAYER_SEND1, index - 4)}) ? 3 : 0;
                    }
                }
                return 0;
            }
            if (!cd.hasLayers()) {
                return index == 7 ? 3 : super.getButtonColor(buttonID);
            }
            if (layer.doesExist()) {
                if (this.configuration.getLockState() == PushConfiguration.LockState.MUTE) {
                    return layer.isMute() ? 0 : 13;
                }
                return layer.isSolo() ? 45 : 1;
            }
        }
        return super.getButtonColor(buttonID);
    }

    protected void drawRow4(ITextDisplay display) {
        int offset = this.getDrumPadIndex();
        for (int i = 0; i < 8; ++i) {
            IChannel layer = (IChannel)this.bank.getItem(offset + i);
            String n = StringUtils.shortenAndFixASCII(layer.getName(), layer.isSelected() ? 7 : 8);
            display.setCell(3, i, (String)(layer.isSelected() ? Push1Display.SELECT_ARROW + n : n));
        }
    }

    protected int getDrumPadIndex() {
        Optional selectedDrumPad;
        if (this.cursorDevice.hasDrumPads() && (selectedDrumPad = this.bank.getSelectedItem()).isPresent() && ((ILayer)selectedDrumPad.get()).getIndex() > 7) {
            return 8;
        }
        return 0;
    }
}

