/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.usb;

import de.mossgrabers.framework.daw.IMemoryBlock;
import de.mossgrabers.framework.usb.IHidCallback;
import de.mossgrabers.framework.usb.IHidDevice;
import de.mossgrabers.framework.usb.UsbException;
import de.mossgrabers.framework.utils.OperatingSystem;
import java.io.IOException;
import java.nio.ByteBuffer;
import purejavahidapi.HidDevice;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.PureJavaHidApi;

public class HidDeviceImpl
implements IHidDevice {
    private HidDevice hidDevice;
    private boolean isOpen;

    public HidDeviceImpl(short vendorID, short productID) throws UsbException {
        HidDeviceInfo hidDeviceInfo = HidDeviceImpl.lookupDevice(vendorID, productID);
        if (hidDeviceInfo == null) {
            throw new UsbException("Could not find HID device: Vendor ID: " + vendorID + ", Product ID: " + productID);
        }
        try {
            this.hidDevice = PureJavaHidApi.openDevice((HidDeviceInfo)hidDeviceInfo);
            this.isOpen = true;
            this.hidDevice.setDeviceRemovalListener(source -> {
                this.isOpen = false;
            });
        }
        catch (IOException ex) {
            throw new UsbException("Could not open HID device: Vendor ID: " + vendorID + ", Product ID: " + productID, ex);
        }
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            this.hidDevice.close();
        }
    }

    @Override
    public int sendOutputReport(byte reportID, IMemoryBlock memoryBlock) {
        byte[] data;
        if (!this.isOpen) {
            return -1;
        }
        byte[] d = data = HidDeviceImpl.toBuffer(memoryBlock);
        int l = data.length;
        if (OperatingSystem.isMacOS()) {
            d = new byte[++l];
            d[0] = reportID;
            System.arraycopy(data, 0, d, 1, data.length);
        }
        return this.hidDevice.setOutputReport(reportID, d, d.length);
    }

    @Override
    public int sendFeatureReport(byte reportID, IMemoryBlock memoryBlock) {
        if (!this.isOpen) {
            return -1;
        }
        byte[] data = HidDeviceImpl.toBuffer(memoryBlock);
        return this.hidDevice.setFeatureReport(reportID, data, data.length);
    }

    @Override
    public void setCallback(IHidCallback callback) {
        if (!this.isOpen) {
            return;
        }
        this.hidDevice.setInputReportListener((source, id, data, length) -> {
            byte[] d = data;
            int l = length;
            if (OperatingSystem.isMacOS()) {
                d = new byte[--l];
                System.arraycopy(data, 1, d, 0, l);
            }
            callback.process(id, d, l);
        });
    }

    private static HidDeviceInfo lookupDevice(short vendorID, short productID) {
        for (HidDeviceInfo info : PureJavaHidApi.enumerateDevices()) {
            if (info.getVendorId() != vendorID || info.getProductId() != productID) continue;
            return info;
        }
        return null;
    }

    private static byte[] toBuffer(IMemoryBlock memoryBlock) {
        ByteBuffer buffer = memoryBlock.createByteBuffer();
        int size = buffer.capacity();
        byte[] data = new byte[size];
        buffer.rewind();
        buffer.get(data);
        return data;
    }
}

