/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device.column;

import de.mossgrabers.reaper.framework.device.DeviceManager;
import de.mossgrabers.reaper.framework.device.column.BaseColumn;
import de.mossgrabers.reaper.framework.device.column.BaseColumnItem;
import java.util.Collections;
import java.util.List;

public class DeviceLocationFilterColumn
extends BaseColumn {
    public DeviceLocationFilterColumn(int columnIndex, int numFilterColumnEntries) {
        super(columnIndex, "Architecture", numFilterColumnEntries);
        for (int i = 0; i < numFilterColumnEntries; ++i) {
            this.items[i] = new DeviceLocationBrowserColumnItem(i);
        }
    }

    @Override
    protected int getMaxNumItems() {
        return 0;
    }

    @Override
    public List<String> getAllItems() {
        return Collections.emptyList();
    }

    private class DeviceLocationBrowserColumnItem
    extends BaseColumnItem {
        public DeviceLocationBrowserColumnItem(int index) {
            super(index);
        }

        @Override
        public int getIndex() {
            return DeviceLocationFilterColumn.this.calcPosition(this.index);
        }

        @Override
        public boolean isSelected() {
            return this.getIndex() == DeviceLocationFilterColumn.this.selectedRow;
        }

        @Override
        protected String getCachedName() {
            return this.position == 0 ? "All" : "";
        }

        @Override
        protected int getCachedHitCount() {
            return this.position == 0 ? DeviceManager.get().getNumDevices() : 0;
        }
    }
}

