/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data.bank;

import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.data.bank.AbstractBankImpl;
import java.util.List;
import java.util.Optional;

public abstract class AbstractPagedBankImpl<S extends T, T extends IItem>
extends AbstractBankImpl<T> {
    protected final T emptyItem;
    protected int bankOffset = 0;

    protected AbstractPagedBankImpl(DataSetupEx dataSetup, int pageSize, T emptyItem) {
        super(dataSetup, pageSize);
        this.emptyItem = emptyItem;
    }

    protected AbstractPagedBankImpl(DataSetupEx dataSetup, int pageSize, T emptyItem, List<T> items) {
        super(dataSetup, pageSize, items);
        this.emptyItem = emptyItem;
    }

    @Override
    public boolean canScrollPageBackwards() {
        return this.bankOffset - this.getPageSize() >= 0;
    }

    @Override
    public boolean canScrollPageForwards() {
        return this.bankOffset + this.getPageSize() < this.getItemCount();
    }

    @Override
    public T getItem(int index) {
        int id = this.bankOffset + index;
        return (T)(id >= 0 && id < this.getItemCount() ? this.getUnpagedItem(id) : this.emptyItem);
    }

    public void setItemCount(int itemCount) {
        this.itemCount = itemCount;
        int ps = this.getPageSize();
        if (ps > 0) {
            this.setBankOffset(Math.min(this.bankOffset, this.itemCount / ps * ps));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S getUnpagedItem(int position) {
        List list = this.items;
        synchronized (list) {
            int size = this.items.size();
            int diff = position - size + 1;
            if (diff > 0) {
                for (int i = 0; i < diff; ++i) {
                    this.items.add(this.createItem(size + i));
                }
            }
            return (S)((IItem)this.items.get(position));
        }
    }

    protected abstract T createItem(int var1);

    @Override
    public int getScrollPosition() {
        return this.bankOffset;
    }

    @Override
    public void selectNextItem() {
        int index;
        Optional sel = this.getSelectedItem();
        int n = index = sel.isEmpty() ? 0 : ((IItem)sel.get()).getIndex() + 1;
        if (index == this.getPageSize()) {
            this.selectNextPage();
        } else {
            this.getItem(index).select();
        }
    }

    @Override
    public void selectPreviousItem() {
        int index;
        Optional sel = this.getSelectedItem();
        int n = index = sel.isEmpty() ? 0 : ((IItem)sel.get()).getIndex() - 1;
        if (index == -1) {
            this.selectPreviousPage();
        } else {
            this.getItem(index).select();
        }
    }

    @Override
    public void selectPreviousPage() {
        if (!this.canScrollPageBackwards()) {
            return;
        }
        this.scrollPageBackwards();
        this.host.scheduleTask(() -> this.getItem(this.getPageSize() - 1).select(), 75L);
    }

    @Override
    public void selectNextPage() {
        if (!this.canScrollPageForwards()) {
            return;
        }
        this.scrollPageForwards();
        this.host.scheduleTask(() -> this.getItem(0).select(), 75L);
    }

    protected void scrollPageBackwards() {
        this.setBankOffset(this.bankOffset - this.getPageSize());
    }

    protected void scrollPageForwards() {
        this.setBankOffset(this.bankOffset + this.getPageSize());
    }

    @Override
    public void scrollBackwards() {
        this.setBankOffset(this.bankOffset - 1);
    }

    @Override
    public void scrollForwards() {
        this.setBankOffset(this.bankOffset + 1);
    }

    protected void setBankOffset(int bankOffset) {
        this.bankOffset = Math.max(0, Math.min(bankOffset, this.getItemCount() - 1));
        this.firePageObserver();
    }
}

