/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data;

import de.mossgrabers.framework.daw.constants.RecordQuantization;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.ISlotBank;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.data.ChannelImpl;
import de.mossgrabers.reaper.framework.daw.data.CrossfadeParameter;
import de.mossgrabers.reaper.framework.daw.data.CursorTrackImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.AbstractTrackBankImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.ParameterBankImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.SceneBankImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.SlotBankImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.TrackBankImpl;
import de.mossgrabers.reaper.framework.daw.data.parameter.ParameterImpl;
import java.util.EnumMap;
import java.util.Map;

public class TrackImpl
extends ChannelImpl
implements ITrack {
    private static final Map<RecordQuantization, Double> QUANT_MAP = new EnumMap<RecordQuantization, Double>(RecordQuantization.class);
    protected final AbstractTrackBankImpl trackBank;
    private boolean isGroupExpanded = true;
    private boolean isRecArm;
    private boolean monitor;
    private boolean autoMonitor;
    private final ISlotBank slotBank;
    private int depth;
    private boolean recordQuantizationNoteLength;
    private RecordQuantization recordQuantization = RecordQuantization.RES_OFF;
    private final IParameter crossfadeParameter;
    private boolean isOverdub = false;
    private final ParameterBankImpl parameterBank;

    public TrackImpl(DataSetupEx dataSetup, AbstractTrackBankImpl trackBank, int index, int numTracks, int numSends, int numScenes, int numParams) {
        super(dataSetup, index, numSends);
        this.trackBank = trackBank;
        this.slotBank = new SlotBankImpl(dataSetup, (SceneBankImpl)trackBank.getSceneBank(), this, numScenes);
        this.crossfadeParameter = new CrossfadeParameter(this.valueChanger, index);
        this.parameterBank = numParams > 0 ? new ParameterBankImpl(dataSetup, Processor.TRACK, numParams, null) : null;
    }

    public TrackImpl(DataSetupEx dataSetup, AbstractTrackBankImpl trackBank, int index, int numTracks, int numSends, int numScenes, int numParams, ParameterImpl volumeParameter, ParameterImpl panParameter) {
        super(dataSetup, index, numSends, volumeParameter, panParameter);
        this.trackBank = trackBank;
        this.slotBank = new SlotBankImpl(dataSetup, (SceneBankImpl)trackBank.getSceneBank(), this, numScenes);
        this.crossfadeParameter = new CrossfadeParameter(this.valueChanger, index);
        this.parameterBank = numParams > 0 ? new ParameterBankImpl(dataSetup, Processor.TRACK, numParams, null) : null;
    }

    @Override
    public void enableObservers(boolean enable) {
    }

    @Override
    public void setName(String name) {
        this.sendPositionedItemOSC("name", name);
    }

    @Override
    public boolean isSelected() {
        CursorTrackImpl cursorTrack = this.dataSetup.getCursorTrack();
        if (cursorTrack.isPinned()) {
            return this == cursorTrack.getPinnedTrack();
        }
        return super.isSelected();
    }

    @Override
    public boolean isMutedBySolo() {
        for (int position = 0; position < this.trackBank.getItemCount(); ++position) {
            ITrack track = (ITrack)this.trackBank.getUnpagedItem(position);
            if (track == this || !track.isSolo()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IParameter getCrossfadeParameter() {
        return this.crossfadeParameter;
    }

    @Override
    public void enter() {
        AbstractTrackBankImpl abstractTrackBankImpl = this.trackBank;
        if (abstractTrackBankImpl instanceof TrackBankImpl) {
            TrackBankImpl tbi = (TrackBankImpl)abstractTrackBankImpl;
            if (this.isGroup()) {
                if (this.isSelected()) {
                    tbi.enterCurrentFolder();
                    return;
                }
                this.select();
                this.host.scheduleTask(((TrackBankImpl)this.trackBank)::enterCurrentFolder, 100L);
            }
        }
    }

    @Override
    public boolean isGroup() {
        return this.getType() == ChannelType.GROUP;
    }

    @Override
    public boolean isGroupExpanded() {
        return this.isGroupExpanded;
    }

    public void setIsGroupExpanded(boolean isGroupExpanded) {
        this.isGroupExpanded = isGroupExpanded;
    }

    @Override
    public void setGroupExpanded(boolean isExpanded) {
        this.isGroupExpanded = isExpanded;
        this.sendPositionedItemOSC("isGroupExpanded", this.isGroupExpanded);
    }

    @Override
    public void toggleGroupExpanded() {
        this.setGroupExpanded(!this.isGroupExpanded);
    }

    @Override
    public boolean hasParent() {
        return this.trackBank.hasParent();
    }

    @Override
    public boolean isRecArm() {
        return this.doesExist() && this.isRecArm;
    }

    @Override
    public void setRecArm(boolean value) {
        this.setRecArmState(value);
        this.sendPositionedItemOSC("recarm", value);
    }

    @Override
    public void toggleRecArm() {
        this.setRecArm(!this.isRecArm());
    }

    @Override
    public boolean isMonitor() {
        return this.doesExist() && this.monitor;
    }

    @Override
    public void setMonitor(boolean value) {
        this.setMonitorState(value);
        this.sendPositionedItemOSC("monitor", this.monitor ? 1 : 0);
    }

    @Override
    public void toggleMonitor() {
        this.setMonitor(!this.monitor);
    }

    @Override
    public boolean isAutoMonitor() {
        return this.doesExist() && this.autoMonitor;
    }

    @Override
    public boolean canHoldNotes() {
        return true;
    }

    @Override
    public void setAutoMonitor(boolean value) {
        this.setAutoMonitorState(value);
        this.sendPositionedItemOSC("autoMonitor", this.autoMonitor);
    }

    @Override
    public void toggleAutoMonitor() {
        this.setAutoMonitor(!this.autoMonitor);
    }

    @Override
    public boolean canHoldAudioData() {
        return true;
    }

    @Override
    public boolean isPlaying() {
        return false;
    }

    @Override
    public void select() {
        if (this.doesExist()) {
            this.sendPositionedItemOSC("select", 1);
        }
    }

    @Override
    public void toggleMultiSelect() {
        if (this.doesExist()) {
            this.sendPositionedItemOSC("toggleMultiSelect", 1);
        }
    }

    public void setRecArmState(boolean isRecArm) {
        this.isRecArm = isRecArm;
    }

    public void setMonitorState(boolean monitorState) {
        this.monitor = monitorState;
    }

    public void setAutoMonitorState(boolean autoMonitorState) {
        this.autoMonitor = autoMonitorState;
    }

    @Override
    public void stop(boolean isAlternative) {
    }

    @Override
    public void returnToArrangement() {
    }

    @Override
    public boolean isRecordQuantizationNoteLength() {
        return this.recordQuantizationNoteLength;
    }

    @Override
    public void toggleRecordQuantizationNoteLength() {
    }

    public void setRecordQuantizationNoteLengthState(boolean isEnabled) {
        this.recordQuantizationNoteLength = isEnabled;
    }

    @Override
    public RecordQuantization getRecordQuantizationGrid() {
        return this.recordQuantization;
    }

    @Override
    public void setRecordQuantizationGrid(RecordQuantization recordQuantization) {
        this.setRecordQuantizationGridState(recordQuantization);
        this.sendPositionedItemOSC("inQuantResolution", QUANT_MAP.get((Object)recordQuantization));
    }

    public void setRecordQuantizationGrid(double resolutionValue) {
        double diff = 1.0;
        RecordQuantization result = RecordQuantization.RES_OFF;
        for (RecordQuantization rq : RecordQuantization.values()) {
            double newDiff = Math.abs(QUANT_MAP.get((Object)rq) - resolutionValue);
            if (!(newDiff < diff)) continue;
            result = rq;
            diff = newDiff;
        }
        this.setRecordQuantizationGridState(result);
    }

    public void setRecordQuantizationGridState(RecordQuantization recordQuantization) {
        this.recordQuantization = recordQuantization;
    }

    @Override
    public ISlotBank getSlotBank() {
        return this.slotBank;
    }

    @Override
    public void createClip(int slotIndex, int lengthInBeats) {
        this.sendPositionedItemOSC("createClip", lengthInBeats);
    }

    @Override
    public boolean hasDrumDevice() {
        return false;
    }

    public IParameterBank getParameterBank() {
        return this.parameterBank;
    }

    public void recordClip() {
        this.sendPositionedItemOSC("recordClip");
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setOverdub(boolean isEnabled) {
        this.isOverdub = isEnabled;
    }

    public boolean isOverdub() {
        return this.isOverdub;
    }

    static {
        QUANT_MAP.put(RecordQuantization.RES_OFF, 0.0);
        QUANT_MAP.put(RecordQuantization.RES_1_32, 0.125);
        QUANT_MAP.put(RecordQuantization.RES_1_16, 0.25);
        QUANT_MAP.put(RecordQuantization.RES_1_8, 0.5);
        QUANT_MAP.put(RecordQuantization.RES_1_4, 1.0);
    }
}

