/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw;

import de.mossgrabers.framework.daw.IClipLauncherNavigator;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ISlotBank;
import de.mossgrabers.framework.utils.LatestTaskExecutor;
import java.util.Optional;

public class ClipLauncherNavigatorImpl
implements IClipLauncherNavigator {
    private final IModel model;
    private final Object navigateLock = new Object();
    private final LatestTaskExecutor slotScrollExecutor = new LatestTaskExecutor();
    private long lastEdit;
    private int targetSlot = -1;

    ClipLauncherNavigatorImpl(IModel model) {
        this.model = model;
    }

    public void shutdown() {
        this.slotScrollExecutor.shutdown();
    }

    @Override
    public void navigateScenes(boolean isLeft) {
        ISceneBank sceneBank = this.model.getSceneBank();
        if (sceneBank == null) {
            return;
        }
        if (isLeft) {
            sceneBank.selectPreviousItem();
        } else {
            sceneBank.selectNextItem();
        }
    }

    @Override
    public void navigateClips(boolean isLeft) {
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        if (!cursorTrack.doesExist()) {
            return;
        }
        ISlotBank slotBank = cursorTrack.getSlotBank();
        if (isLeft) {
            slotBank.selectPreviousItem();
        } else {
            slotBank.selectNextItem();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void navigateTracks(boolean isLeft) {
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        if (!cursorTrack.doesExist()) {
            ITrack track = (ITrack)this.model.getTrackBank().getItem(0);
            if (!track.doesExist()) {
                return;
            }
            track.select();
        }
        Object object = this.navigateLock;
        synchronized (object) {
            ISlotBank slotBank = cursorTrack.getSlotBank();
            Optional selectedSlot = slotBank.getSelectedItem();
            if (this.targetSlot == -1) {
                if (selectedSlot.isPresent()) {
                    this.targetSlot = ((ISlot)selectedSlot.get()).getIndex();
                } else {
                    int n = this.targetSlot = slotBank.getItemCount() > 0 && ((ISlot)slotBank.getItem(0)).doesExist() ? 0 : -1;
                }
            }
            if (isLeft) {
                cursorTrack.selectPrevious();
            } else {
                cursorTrack.selectNext();
            }
            this.lastEdit = System.currentTimeMillis();
            this.slotScrollExecutor.execute(this::selectSlot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectTrack(int index) {
        ITrack track = (ITrack)this.model.getTrackBank().getItem(index);
        if (!track.doesExist()) {
            return;
        }
        if (track.isSelected()) {
            if (track.isGroup()) {
                track.toggleGroupExpanded();
            }
            return;
        }
        Object object = this.navigateLock;
        synchronized (object) {
            ICursorTrack cursorTrack = this.model.getCursorTrack();
            boolean doesExist = cursorTrack.doesExist();
            if (doesExist) {
                ISlotBank slotBank = cursorTrack.getSlotBank();
                Optional selectedSlot = slotBank.getSelectedItem();
                if (this.targetSlot == -1) {
                    this.targetSlot = selectedSlot.isPresent() ? ((ISlot)selectedSlot.get()).getIndex() : (slotBank.getItemCount() > 0 && ((ISlot)slotBank.getItem(0)).doesExist() ? 0 : -1);
                }
            }
            track.select();
            if (doesExist) {
                this.lastEdit = System.currentTimeMillis();
                this.slotScrollExecutor.execute(this::selectSlot);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectSlot() {
        Object object = this.navigateLock;
        synchronized (object) {
            if (this.targetSlot < 0) {
                return;
            }
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return;
        }
        object = this.navigateLock;
        synchronized (object) {
            long diff = System.currentTimeMillis() - this.lastEdit;
            if (diff > 2000L) {
                this.targetSlot = -1;
                return;
            }
            if (diff > 200L) {
                ICursorTrack cursorTrack = this.model.getCursorTrack();
                ((ISlot)cursorTrack.getSlotBank().getItem(this.targetSlot)).select();
            }
            this.slotScrollExecutor.execute(this::selectSlot);
        }
    }
}

