/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.configuration;

import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.observer.ISettingObserver;
import de.mossgrabers.framework.view.Views;
import java.util.List;

public interface Configuration {
    public void addSettingObserver(Integer var1, ISettingObserver var2);

    public void removeSettingObserver(Integer var1, ISettingObserver var2);

    public void notifyAllObservers();

    public void clearSettingObservers();

    public boolean canSettingBeObserved(Integer var1);

    public String getScale();

    public void setScale(String var1);

    public String getScaleBase();

    public void setScaleBase(String var1);

    public boolean isScaleInKey();

    public void setScaleInKey(boolean var1);

    public String getScaleLayout();

    public void setScaleLayout(String var1);

    public boolean isEnableVUMeters();

    public AbstractConfiguration.TransportBehavior getBehaviourOnStop();

    public AbstractConfiguration.TransportBehavior getBehaviourOnPause();

    public boolean isFlipRecord();

    public boolean isAccentActive();

    public int getFixedAccentValue();

    public int getQuantizeAmount();

    public int getConvertAftertouch();

    public boolean isFlipSession();

    public void setFlipSession(boolean var1);

    public boolean isSelectClipOnLaunch();

    public int getNewClipLength();

    public int getNewClipLenghthInBeats(int var1);

    public void setNewClipLength(int var1);

    public void nextNewClipLength();

    public boolean isAutoSelectDrum();

    public boolean isTurnOffEmptyDrumPads();

    public boolean isTurnOffScalePads();

    public boolean isCombinationButtonToSoundDrumPads();

    public boolean isDrawRecordStripe();

    public int getActionForRecArmedPad();

    public void init(ISettingsUI var1, ISettingsUI var2);

    public void setVUMetersEnabled(boolean var1);

    public void setAccentEnabled(boolean var1);

    public void setFixedAccentValue(int var1);

    public void changeQuantizeAmount(int var1);

    public void setQuantizeAmount(int var1);

    public void resetQuantizeAmount();

    public int getFootswitch(int var1);

    public int getKnobSensitivityDefault();

    public int getKnobSensitivitySlow();

    public int getEncoderKnobSlowDown();

    public List<ArpeggiatorMode> getArpeggiatorModes();

    public int lookupArpeggiatorModeIndex(ArpeggiatorMode var1);

    public boolean isNoteRepeatActive();

    public void setNoteRepeatActive(boolean var1);

    public void toggleNoteRepeatActive();

    public Resolution getNoteRepeatPeriod();

    public void setNoteRepeatPeriod(Resolution var1);

    public Resolution getNoteRepeatLength();

    public ArpeggiatorMode getNoteRepeatMode();

    public void setNoteRepeatLength(Resolution var1);

    public int getNoteRepeatOctave();

    public void setNoteRepeatOctave(int var1);

    public void setNoteRepeatMode(ArpeggiatorMode var1);

    default public void setPrevNextNoteRepeatMode(boolean increase) {
        ArpeggiatorMode arpMode = this.getNoteRepeatMode();
        int modeIndex = this.lookupArpeggiatorModeIndex(arpMode);
        List<ArpeggiatorMode> modes = this.getArpeggiatorModes();
        int newIndex = Math.max(0, Math.min(modes.size() - 1, modeIndex + (increase ? 1 : -1)));
        this.setNoteRepeatMode(modes.get(newIndex));
    }

    public int getMidiEditChannel();

    public void setMidiEditChannel(int var1);

    public AbstractConfiguration.RecordFunction getRecordButtonFunction();

    public AbstractConfiguration.RecordFunction getShiftedRecordButtonFunction();

    public Views getStartupView();

    public Modes getStartupMode();

    public Views getPreferredAudioView();

    public boolean shouldStartWithSessionView();

    public boolean isShowPlayedChords();
}

