/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.yaeltex.turn.mode;

import de.mossgrabers.controller.yaeltex.turn.YaeltexTurnConfiguration;
import de.mossgrabers.controller.yaeltex.turn.controller.YaeltexTurnColorManager;
import de.mossgrabers.controller.yaeltex.turn.controller.YaeltexTurnControlSurface;
import de.mossgrabers.controller.yaeltex.turn.mode.YaeltexTurnTrackMixMode;
import de.mossgrabers.controller.yaeltex.turn.view.MonophonicSequencerView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.display.IDisplay;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.mode.INoteEditor;
import de.mossgrabers.framework.mode.INoteEditorMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameter.NoteAttribute;
import de.mossgrabers.framework.parameter.NoteParameter;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.NullParameterProvider;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.view.Views;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class YaeltexTurnNoteSeqMode
extends YaeltexTurnTrackMixMode
implements INoteEditorMode,
INoteEditor {
    private static final NoteAttribute[] NOTE_ATTRIBUTES = new NoteAttribute[]{NoteAttribute.PITCH, NoteAttribute.MUTE, NoteAttribute.DURATION, NoteAttribute.VELOCITY, NoteAttribute.RELEASE_VELOCITY, NoteAttribute.VELOCITY_SPREAD, NoteAttribute.GAIN, NoteAttribute.PANNING, NoteAttribute.PRESSURE, NoteAttribute.TIMBRE, NoteAttribute.CHANCE, NoteAttribute.OCCURRENCE, NoteAttribute.REPEAT, NoteAttribute.REPEAT_CURVE, NoteAttribute.REPEAT_VELOCITY_CURVE, NoteAttribute.REPEAT_VELOCITY_END};
    private final Map<NoteAttribute, IParameterProvider> noteEditProviders = new EnumMap<NoteAttribute, IParameterProvider>(NoteAttribute.class);
    private final YaeltexTurnConfiguration configuration;
    private NoteAttribute noteEditParameter = NoteAttribute.PITCH;

    public YaeltexTurnNoteSeqMode(YaeltexTurnControlSurface surface, IModel model, List<ContinuousID> controls) {
        super("Monophonic Sequencer", surface, model, controls);
        this.configuration = (YaeltexTurnConfiguration)((YaeltexTurnControlSurface)this.surface).getConfiguration();
        IValueChanger valueChanger = model.getValueChanger();
        IDisplay display = surface.getDisplay();
        for (NoteAttribute attribute : NoteAttribute.values()) {
            ArrayList<IParameter> parameters = new ArrayList<IParameter>(32);
            for (int i = 0; i < 32; ++i) {
                parameters.add(new NoteParameter(i, attribute, display, model, this, valueChanger));
            }
            this.noteEditProviders.put(attribute, new FixedParameterProvider(parameters));
        }
        this.providers.add(0, new NullParameterProvider(32));
        this.rebind();
    }

    @Override
    public int getKnobValue(int index) {
        return this.noteEditProviders.get((Object)this.noteEditParameter).get(index).getValue();
    }

    @Override
    public int getKnobColor(int index) {
        return ((YaeltexTurnColorManager)this.colorManager).getParamColor(this.noteEditParameter);
    }

    @Override
    protected void onShiftButton(int row, int index) {
        IHost host = this.model.getHost();
        if (row == 0 || row == 1) {
            int noteParamIndex = 2 * index + row;
            if (!host.supports(NOTE_ATTRIBUTES[noteParamIndex])) {
                return;
            }
            this.noteEditParameter = NOTE_ATTRIBUTES[noteParamIndex];
            this.rebind();
            host.showNotification(this.noteEditProviders.get((Object)this.noteEditParameter).get(0).getName());
            return;
        }
        if (row == 2 || row == 3) {
            Scales scales = this.model.getScales();
            int scaleIndex = 2 * index + row - 2;
            IDisplay display = ((YaeltexTurnControlSurface)this.surface).getDisplay();
            switch (scaleIndex) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    scales.setScaleOffsetByName(Scales.NOTE_NAMES.get(scaleIndex));
                    String scaleBase = Scales.BASES.get(scales.getScaleOffsetIndex());
                    this.configuration.setScaleBase(scaleBase);
                    display.notify(scaleBase);
                    return;
                }
                case 13: {
                    boolean isInKey = !this.configuration.isScaleInKey();
                    this.configuration.setScaleInKey(isInKey);
                    display.notify(isInKey ? "In Key" : "Chromatic");
                    return;
                }
                case 14: {
                    scales.prevScale();
                    String prevScale = scales.getScale().getName();
                    ((YaeltexTurnConfiguration)((YaeltexTurnControlSurface)this.surface).getConfiguration()).setScale(prevScale);
                    display.notify(prevScale);
                    return;
                }
                case 15: {
                    scales.nextScale();
                    String nextScale = scales.getScale().getName();
                    ((YaeltexTurnConfiguration)((YaeltexTurnControlSurface)this.surface).getConfiguration()).setScale(nextScale);
                    display.notify(nextScale);
                    return;
                }
            }
            return;
        }
        INoteClip clip = this.getClip();
        if (row == 4) {
            Resolution resolution = Resolution.values()[index];
            clip.setStepLength(resolution.getValue());
            host.showNotification("Grid res.: " + resolution.getName());
        }
        if (row == 5 && clip.getEditPage() != index) {
            clip.scrollToPage(index);
            host.showNotification("Edit Page: " + (index + 1));
        }
    }

    @Override
    protected int getButtonShiftColor(ButtonID buttonID) {
        int noteParamIndex = -1;
        int scaleIndex = -1;
        switch (buttonID) {
            case ROW1_1: 
            case ROW1_2: 
            case ROW1_3: 
            case ROW1_4: 
            case ROW1_5: 
            case ROW1_6: 
            case ROW1_7: 
            case ROW1_8: {
                noteParamIndex = 2 * (buttonID.ordinal() - ButtonID.ROW1_1.ordinal());
                break;
            }
            case ROW2_1: 
            case ROW2_2: 
            case ROW2_3: 
            case ROW2_4: 
            case ROW2_5: 
            case ROW2_6: 
            case ROW2_7: 
            case ROW2_8: {
                noteParamIndex = 2 * (buttonID.ordinal() - ButtonID.ROW2_1.ordinal()) + 1;
                break;
            }
            case ROW3_1: 
            case ROW3_2: 
            case ROW3_3: 
            case ROW3_4: 
            case ROW3_5: 
            case ROW3_6: 
            case ROW3_7: 
            case ROW3_8: {
                scaleIndex = 2 * (buttonID.ordinal() - ButtonID.ROW3_1.ordinal());
                break;
            }
            case ROW4_1: 
            case ROW4_2: 
            case ROW4_3: 
            case ROW4_4: 
            case ROW4_5: 
            case ROW4_6: 
            case ROW4_7: 
            case ROW4_8: {
                scaleIndex = 2 * (buttonID.ordinal() - ButtonID.ROW4_1.ordinal()) + 1;
                break;
            }
            case ROW5_1: 
            case ROW5_2: 
            case ROW5_3: 
            case ROW5_4: 
            case ROW5_5: 
            case ROW5_6: 
            case ROW5_7: 
            case ROW5_8: {
                int index = buttonID.ordinal() - ButtonID.ROW5_1.ordinal();
                int selectedResolutionIndex = Resolution.getMatch(this.getClip().getStepLength());
                return selectedResolutionIndex == index ? YaeltexTurnColorManager.GREEN : 127;
            }
            case ROW6_1: 
            case ROW6_2: 
            case ROW6_3: 
            case ROW6_4: 
            case ROW6_5: 
            case ROW6_6: 
            case ROW6_7: 
            case ROW6_8: {
                int page = buttonID.ordinal() - ButtonID.ROW6_1.ordinal();
                return this.getClip().getEditPage() == page ? YaeltexTurnColorManager.BLUE : 127;
            }
        }
        if (noteParamIndex != -1) {
            return ((YaeltexTurnColorManager)this.colorManager).getParamColor(NOTE_ATTRIBUTES[noteParamIndex]);
        }
        if (scaleIndex != -1) {
            switch (scaleIndex) {
                case 0: 
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 11: {
                    return this.model.getScales().getScaleOffset() == scaleIndex ? YaeltexTurnColorManager.GREEN : 127;
                }
                case 1: 
                case 3: 
                case 6: 
                case 8: 
                case 10: {
                    return this.model.getScales().getScaleOffset() == scaleIndex ? YaeltexTurnColorManager.GREEN : YaeltexTurnColorManager.BLUE;
                }
                default: {
                    return 0;
                }
                case 13: {
                    return this.model.getScales().isChromatic() ? YaeltexTurnColorManager.GRAY : YaeltexTurnColorManager.CYAN;
                }
                case 14: 
                case 15: 
            }
            return YaeltexTurnColorManager.PINK;
        }
        return 0;
    }

    @Override
    public INoteEditor getNoteEditor() {
        return this;
    }

    @Override
    public INoteClip getClip() {
        return ((MonophonicSequencerView)((YaeltexTurnControlSurface)this.surface).getViewManager().get(Views.SEQUENCER)).getClip();
    }

    @Override
    public void clearNotes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNote(INoteClip clip, NotePosition notePosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addNote(INoteClip clip, NotePosition notePosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeNote(INoteClip clip, NotePosition notePosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNoteEdited(INoteClip clip, NotePosition notePosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<NotePosition> getNotes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<NotePosition> getNotePosition(int parameterIndex) {
        int channel = this.configuration.getMidiEditChannel();
        int noteRow = this.getClip().getHighestRow(channel, parameterIndex);
        if (noteRow == -1) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new NotePosition(channel, parameterIndex, noteRow));
    }

    private void rebind() {
        this.providers.set(0, this.noteEditProviders.get((Object)this.noteEditParameter));
        this.setParameterProvider(new CombinedParameterProvider(this.providers));
        this.bindControls();
    }
}

