/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.hui.controller;

import de.mossgrabers.framework.controller.display.AbstractTextDisplay;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Arrays;
import java.util.Locale;

public class HUISegmentDisplay
extends AbstractTextDisplay {
    private static final String SYSEX_HDR = "F0 00 00 66 05 00 11 ";
    private final int[] transportBuffer = new int[8];
    private final int[] oldtransportBuffer = new int[8];

    public HUISegmentDisplay(IHost host, IMidiOutput output) {
        super(host, output, 1, 1, 8);
        Arrays.fill(this.oldtransportBuffer, -1);
    }

    @Override
    public void writeLine(int row, String text, String previousText) {
        String lowerText = text.toLowerCase(Locale.US);
        Arrays.fill(this.transportBuffer, 0);
        int index = 0;
        for (int i = lowerText.length() - 1; i >= 0; --i) {
            char c = lowerText.charAt(i);
            if (c == ':') {
                int n = index;
                this.transportBuffer[n] = this.transportBuffer[n] + 16;
                continue;
            }
            int value = c - 48;
            if (value < 0 || value > 9) {
                value = 0;
            }
            int n = index++;
            this.transportBuffer[n] = this.transportBuffer[n] + value;
            if (index >= 8) break;
        }
        int pos = 7;
        for (int i = 7; i >= 0 && this.transportBuffer[i] == this.oldtransportBuffer[i]; --i) {
            --pos;
        }
        if (pos == -1) {
            return;
        }
        System.arraycopy(this.transportBuffer, 0, this.oldtransportBuffer, 0, pos + 1);
        int[] data = new int[pos + 1];
        System.arraycopy(this.transportBuffer, 0, data, 0, data.length);
        String msg = SYSEX_HDR + StringUtils.toHexStr(data) + "F7";
        this.output.sendSysex(msg);
    }

    @Override
    public void shutdown() {
    }
}

