/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.intuitiveinstruments.exquis.controller;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.DAWColor;

public class ExquisColorManager
extends ColorManager {
    public static final int FIRST_DAW_COLOR_INDEX = 50;
    public static final int COLOR_BUTTON_STATE_ON = 127;
    public static final int COLOR_BUTTON_STATE_OFF = 0;
    public static final int BLACK = 101;
    public static final int DARK_GREY = 102;
    public static final int WHITE = 103;
    public static final int DARK_RED = 104;
    public static final int RED = 105;
    public static final int DARKER_BLUE = 106;
    public static final int BLUE = 107;
    public static final int DARKER_YELLOW = 108;
    public static final int YELLOW = 109;
    public static final int DARKER_GREEN = 110;
    public static final int GREEN = 111;
    public static final int DARKER_ORANGE = 112;
    public static final int DARK_ORANGE = 113;
    public static final int ORANGE = 114;
    public static final String RECORD_OFF = "RECORD_OFF";
    public static final String RECORD_ON = "RECORD_ON";
    public static final String LOOP_OFF = "LOOP_OFF";
    public static final String LOOP_ON = "LOOP_ON";
    public static final String SESSION_OFF = "SESSION_OFF";
    public static final String SESSION_ON = "SESSION_ON";
    public static final String PLAY_OFF = "PLAY_OFF";
    public static final String PLAY_ON = "PLAY_ON";
    public static final String DO_OFF = "DO_OFF";
    public static final String DO_ON = "DO_ON";
    public static final String TRACKS_COLOR = "TRACKS_COLOR";

    public ExquisColorManager() {
        this.registerColorIndex("BUTTON_COLOR_OFF", 0);
        this.registerColorIndex("BUTTON_STATE_OFF", 0);
        this.registerColorIndex("BUTTON_STATE_ON", 127);
        this.registerColorIndex("BUTTON_STATE_HI", 127);
        this.registerColorIndex("GRID_COLOR_OFF", 0);
        this.registerColorIndex("COLOR_SCENE", 110);
        this.registerColorIndex("COLOR_SELECTED_SCENE", 111);
        this.registerColorIndex("COLOR_SELECTED_OFF", 101);
        this.registerColorIndex(RECORD_OFF, 104);
        this.registerColorIndex(RECORD_ON, 105);
        this.registerColorIndex(LOOP_OFF, 106);
        this.registerColorIndex(LOOP_ON, 107);
        this.registerColorIndex(SESSION_OFF, 108);
        this.registerColorIndex(SESSION_ON, 109);
        this.registerColorIndex(PLAY_OFF, 110);
        this.registerColorIndex(PLAY_ON, 111);
        this.registerColorIndex(DO_OFF, 101);
        this.registerColorIndex(DO_ON, 103);
        this.registerColorIndex(TRACKS_COLOR, 106);
        this.registerColor(0, ColorEx.BLACK);
        this.registerColor(127, ColorEx.WHITE);
        this.registerColor(101, ColorEx.BLACK);
        this.registerColor(102, ColorEx.DARK_GRAY);
        this.registerColor(103, ColorEx.WHITE);
        this.registerColor(104, ColorEx.DARKER_RED);
        this.registerColor(105, ColorEx.RED);
        this.registerColor(106, ColorEx.DARKER_BLUE);
        this.registerColor(107, ColorEx.BLUE);
        this.registerColor(108, ColorEx.DARKER_YELLOW);
        this.registerColor(109, ColorEx.YELLOW);
        this.registerColor(110, ColorEx.DARKER_GREEN);
        this.registerColor(111, ColorEx.GREEN);
        this.registerColor(114, ColorEx.ORANGE);
        this.registerColor(113, ColorEx.DARK_ORANGE);
        this.registerColor(112, ColorEx.DARKER_ORANGE);
        DAWColor[] dawColors = DAWColor.values();
        for (int i = 0; i < dawColors.length; ++i) {
            DAWColor dawColor = dawColors[i];
            this.registerColorIndex(dawColor, 50 + i);
            this.registerColor(50 + i, dawColor.getColor());
        }
    }
}

