/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.view;

import de.mossgrabers.controller.akai.fire.FireConfiguration;
import de.mossgrabers.controller.akai.fire.controller.FireControlSurface;
import de.mossgrabers.controller.akai.fire.view.IFireView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.INoteEditorMode;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.sequencer.AbstractPolySequencerView;

public class PolySequencerView
extends AbstractPolySequencerView<FireControlSurface, FireConfiguration>
implements IFireView {
    public PolySequencerView(FireControlSurface surface, IModel model, boolean useTrackColor) {
        super(surface, model, useTrackColor, 16, 4, 2);
    }

    @Override
    public int getSoloButtonColor(int index) {
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return cursorTrack.doesExist() && cursorTrack.isMute() ? 3 : 0;
            }
            case 2: {
                return cursorTrack.doesExist() && cursorTrack.isSolo() ? 4 : 0;
            }
            case 3: {
                return cursorTrack.doesExist() && cursorTrack.isRecArm() ? 1 : 0;
            }
        }
        return 0;
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        switch (buttonID) {
            case SCENE1: 
            case SCENE2: 
            case SCENE3: 
            case SCENE4: {
                return 0;
            }
        }
        return super.getButtonColor(buttonID);
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (event != ButtonEvent.DOWN || !this.isActive()) {
            return;
        }
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        INoteClip clip = this.getClip();
        switch (buttonID) {
            case ARROW_LEFT: {
                if (((FireControlSurface)this.surface).isPressed(ButtonID.ALT)) {
                    this.setResolutionIndex(this.getResolutionIndex() - 1);
                    break;
                }
                clip.scrollStepsPageBackwards();
                this.mvHelper.notifyEditPage(clip);
                break;
            }
            case ARROW_RIGHT: {
                if (((FireControlSurface)this.surface).isPressed(ButtonID.ALT)) {
                    this.setResolutionIndex(this.getResolutionIndex() + 1);
                    break;
                }
                clip.scrollStepsPageForward();
                this.mvHelper.notifyEditPage(clip);
                break;
            }
            case SCENE1: {
                cursorTrack.stop(false);
                break;
            }
            case SCENE2: {
                cursorTrack.toggleMute();
                break;
            }
            case SCENE3: {
                cursorTrack.toggleSolo();
                break;
            }
            case SCENE4: {
                cursorTrack.toggleRecArm();
                break;
            }
        }
    }

    @Override
    public void onSelectKnobValue(int value) {
        if (this.model.getValueChanger().isIncrease(value)) {
            this.onOctaveUp(ButtonEvent.DOWN);
        } else {
            this.onOctaveDown(ButtonEvent.DOWN);
        }
    }

    @Override
    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, int channel, int step) {
        ModeManager modeManager = ((FireControlSurface)this.surface).getModeManager();
        IMode activeMode = (IMode)modeManager.getActive();
        if (activeMode instanceof INoteEditorMode) {
            INoteEditorMode noteMode = (INoteEditorMode)((Object)activeMode);
            NotePosition notePosition = new NotePosition(channel, step, 0);
            for (int row = 0; row < 128; ++row) {
                notePosition.setNote(row);
                if (clip.getStep(notePosition).getState() != StepState.START) continue;
                this.editNote(clip, notePosition, true);
            }
            if (noteMode.getNoteEditor().getNotes().isEmpty()) {
                ((FireControlSurface)this.surface).getDisplay().notify("Edit Notes: Off");
            }
            return true;
        }
        return super.handleSequencerAreaButtonCombinations(clip, channel, step);
    }
}

