/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apcmini.view;

import de.mossgrabers.controller.akai.apcmini.APCminiConfiguration;
import de.mossgrabers.controller.akai.apcmini.controller.APCminiControlSurface;
import de.mossgrabers.controller.akai.apcmini.view.APCminiView;
import de.mossgrabers.controller.akai.apcmini.view.TrackButtons;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.grid.LightInfo;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractSessionView;

public class SessionView
extends AbstractSessionView<APCminiControlSurface, APCminiConfiguration>
implements APCminiView {
    private final TrackButtons extensions;

    public SessionView(APCminiControlSurface surface, IModel model, TrackButtons trackButtons, boolean useTrackColor) {
        super("Session", surface, model, 8, 8, useTrackColor);
        this.extensions = trackButtons;
        if (useTrackColor) {
            this.ignoreClipColorForPlayAndRecord = true;
            LightInfo isRecording = new LightInfo(5, 5, false);
            LightInfo isRecordingQueued = new LightInfo(5, 5, true);
            LightInfo isPlaying = new LightInfo(21, 21, false);
            LightInfo isPlayingQueued = new LightInfo(21, 21, true);
            LightInfo isStopQueued = new LightInfo(21, 21, true);
            LightInfo hasContent = new LightInfo(9, 3, false);
            LightInfo noContent = new LightInfo(0, -1, false);
            LightInfo recArmed = new LightInfo(6, -1, false);
            LightInfo isMuted = new LightInfo(71, -1, false);
            this.setColors(isRecording, isRecordingQueued, isPlaying, isPlayingQueued, isStopQueued, hasContent, noContent, recArmed, isMuted);
        } else {
            LightInfo isRecording = new LightInfo(3, -1, false);
            LightInfo isRecordingQueued = new LightInfo(3, 4, false);
            LightInfo isPlaying = new LightInfo(1, -1, false);
            LightInfo isPlayingQueued = new LightInfo(1, 2, false);
            LightInfo isStopQueued = new LightInfo(1, 2, false);
            LightInfo hasContent = new LightInfo(5, 6, false);
            LightInfo noContent = new LightInfo(0, -1, false);
            LightInfo recArmed = new LightInfo(0, -1, false);
            LightInfo isMuted = new LightInfo(0, -1, false);
            this.setColors(isRecording, isRecordingQueued, isPlaying, isPlayingQueued, isStopQueued, hasContent, noContent, recArmed, isMuted);
        }
    }

    @Override
    public boolean doSelectClipOnLaunch() {
        return ((APCminiConfiguration)((APCminiControlSurface)this.surface).getConfiguration()).isSelectClipOnLaunch();
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        super.onButton(buttonID, event, velocity);
        if (ButtonID.isSceneButton(buttonID) && event == ButtonEvent.UP && ((APCminiControlSurface)this.surface).isShiftPressed()) {
            this.setAlternateInteractionUsed(true);
        }
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        int scene = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        if (scene < 0 || scene >= 8) {
            return "BUTTON_COLOR_OFF";
        }
        ISceneBank sceneBank = this.model.getSceneBank();
        IScene s = (IScene)sceneBank.getItem(scene);
        if (s.doesExist()) {
            return s.isSelected() ? "COLOR_SELECTED_SCENE" : "COLOR_SCENE";
        }
        return "COLOR_SELECTED_OFF";
    }

    @Override
    public void onSelectTrack(int index, ButtonEvent event) {
        this.extensions.onSelectTrack(index, event);
    }

    @Override
    public int getTrackButtonColor(int index) {
        return this.extensions.getTrackButtonColor(index);
    }
}

