/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data.parameter;

import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.data.ItemImpl;
import de.mossgrabers.reaper.framework.daw.data.parameter.IParameterEx;

public class ParameterImpl
extends ItemImpl
implements IParameterEx {
    private String valueStr = "";
    private boolean isBeingTouched;
    protected double value;
    protected double lastReceivedValue = -1.0;
    private int numberOfSteps;
    private final int defaultValue;
    private final Processor processor;

    public ParameterImpl(DataSetupEx dataSetup, int index, double defaultValue) {
        this(dataSetup, Processor.DEVICE, index, defaultValue);
    }

    public ParameterImpl(DataSetupEx dataSetup, Processor processor, int index, double defaultValue) {
        super(dataSetup, index);
        this.processor = processor;
        this.defaultValue = this.valueChanger.fromNormalizedValue(defaultValue);
    }

    @Override
    public void inc(double increment) {
        this.setValue((int)Math.max(0.0, Math.min((double)this.getValue() + increment, (double)this.valueChanger.getUpperBound() - 1.0)));
    }

    @Override
    public String getDisplayedValue() {
        return this.valueStr;
    }

    @Override
    public String getDisplayedValue(int limit) {
        String displayedValue = this.getDisplayedValue();
        int length = displayedValue.length();
        return length > limit ? displayedValue.substring(0, length) : displayedValue;
    }

    @Override
    public int getValue() {
        return this.valueChanger.fromNormalizedValue(Math.max(this.value, 0.0));
    }

    @Override
    public double getInternalValue() {
        return Math.max(this.value, 0.0);
    }

    @Override
    public void changeValue(int control) {
        this.changeValue(this.valueChanger, control);
    }

    @Override
    public void changeValue(IValueChanger valueChanger, int control) {
        double offset = valueChanger.calcKnobChange(control);
        boolean isNegative = offset < 0.0;
        offset = valueChanger.toNormalizedValue(Math.abs(offset));
        if (isNegative) {
            offset = -offset;
        }
        this.setNormalizedValue(Math.min(1.0, Math.max(0.0, this.getInternalValue() + offset)));
    }

    @Override
    public void setValue(int value) {
        this.setNormalizedValue(this.valueChanger.toNormalizedValue(value));
    }

    @Override
    public void setValue(IValueChanger valueChanger, int value) {
        this.setNormalizedValue(valueChanger.toNormalizedValue(value));
    }

    @Override
    public void setNormalizedValue(double value) {
        if (!this.doesExist()) {
            return;
        }
        this.value = value;
        this.sendValue();
    }

    @Override
    public void setValueImmediatly(int value) {
        this.setValue(value);
    }

    @Override
    public int getModulatedValue() {
        return this.getValue();
    }

    @Override
    public void setIndication(boolean enable) {
    }

    @Override
    public void resetValue() {
        this.setValue(this.defaultValue);
    }

    @Override
    public void touchValue(boolean isBeingTouched) {
        this.isBeingTouched = isBeingTouched;
        if (this.isBeingTouched || this.lastReceivedValue < 0.0) {
            return;
        }
        this.value = this.lastReceivedValue;
        this.lastReceivedValue = -1.0;
    }

    @Override
    public void setInternalValue(double value) {
        if (this.isBeingTouched) {
            this.lastReceivedValue = value;
        } else {
            this.value = value;
        }
    }

    @Override
    public void setValueStr(String valueStr) {
        this.valueStr = valueStr == null ? "" : valueStr;
    }

    protected void sendValue() {
        this.sendPositionedItemOSC("value", this.value);
    }

    @Override
    protected String createCommand(String command) {
        ITrack pinnedOrSelectedTrack;
        String cmd = "param/" + super.createCommand(command);
        if (this.processor == Processor.TRACK && (pinnedOrSelectedTrack = this.dataSetup.getCursorTrack().getPinnedOrSelectedTrack()) != null) {
            cmd = pinnedOrSelectedTrack.getPosition() + "/" + cmd;
        }
        return cmd;
    }

    @Override
    protected Processor getProcessor() {
        return this.processor;
    }

    public String toString() {
        return this.getPosition() + ": " + this.getName();
    }

    public void copyValues(ParameterImpl destParam) {
        destParam.setInternalName(this.name);
        destParam.setExists(this.exists);
        destParam.setInternalValue(this.value);
        destParam.setValueStr(this.valueStr);
    }

    @Override
    public int getNumberOfSteps() {
        return this.numberOfSteps;
    }

    @Override
    public void setInternalNumberOfSteps(int numberOfSteps) {
        this.numberOfSteps = numberOfSteps;
    }
}

