/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.AbstractModel;
import de.mossgrabers.framework.daw.ModelSetup;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.IDrumDevice;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ISlotBank;
import de.mossgrabers.framework.parameter.IFocusedParameter;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.FrameworkException;
import de.mossgrabers.reaper.framework.IniFiles;
import de.mossgrabers.reaper.framework.daw.ApplicationImpl;
import de.mossgrabers.reaper.framework.daw.ArrangerImpl;
import de.mossgrabers.reaper.framework.daw.BrowserImpl;
import de.mossgrabers.reaper.framework.daw.ClipLauncherNavigatorImpl;
import de.mossgrabers.reaper.framework.daw.CursorClipImpl;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.GrooveImpl;
import de.mossgrabers.reaper.framework.daw.KompleteDevice;
import de.mossgrabers.reaper.framework.daw.MixerImpl;
import de.mossgrabers.reaper.framework.daw.Note;
import de.mossgrabers.reaper.framework.daw.ProjectImpl;
import de.mossgrabers.reaper.framework.daw.TransportImpl;
import de.mossgrabers.reaper.framework.daw.data.CursorDeviceImpl;
import de.mossgrabers.reaper.framework.daw.data.CursorLayerImpl;
import de.mossgrabers.reaper.framework.daw.data.CursorTrackImpl;
import de.mossgrabers.reaper.framework.daw.data.DrumDeviceImpl;
import de.mossgrabers.reaper.framework.daw.data.EqualizerDeviceImpl;
import de.mossgrabers.reaper.framework.daw.data.MasterTrackImpl;
import de.mossgrabers.reaper.framework.daw.data.SlotImpl;
import de.mossgrabers.reaper.framework.daw.data.TrackImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.MarkerBankImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.ResizedSlotBank;
import de.mossgrabers.reaper.framework.daw.data.bank.SceneBankImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.SlotBankImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.TrackBankImpl;
import de.mossgrabers.reaper.framework.daw.data.parameter.FocusedParameterImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ModelImpl
extends AbstractModel {
    private final DataSetupEx dataSetup;
    private final Map<Integer, SceneBankImpl> sceneBanks = new HashMap<Integer, SceneBankImpl>(1);
    private final Map<Integer, ISlotBank> slotBanks = new HashMap<Integer, ISlotBank>(1);
    private final FocusedParameterImpl focusedParameter;

    public ModelImpl(Configuration configuration, ModelSetup modelSetup, DataSetupEx dataSetup, Scales scales, IniFiles iniFiles) {
        super(modelSetup, dataSetup, scales);
        this.dataSetup = dataSetup;
        int numParams = modelSetup.getNumParams();
        int numListParams = modelSetup.getNumListParams();
        int numTracks = modelSetup.getNumTracks();
        int numSends = modelSetup.getNumSends();
        int numScenes = modelSetup.getNumScenes();
        int numDevicesInBank = modelSetup.getNumDevicesInBank();
        int numDeviceLayers = modelSetup.getNumDeviceLayers();
        int numDrumPadLayers = modelSetup.getNumDrumPadLayers();
        this.application = new ApplicationImpl(dataSetup);
        this.arranger = new ArrangerImpl(dataSetup);
        this.mixer = new MixerImpl(dataSetup);
        this.project = new ProjectImpl(dataSetup, this, configuration, numParams);
        this.transport = new TransportImpl(dataSetup, this);
        this.groove = new GrooveImpl(dataSetup);
        this.markerBank = new MarkerBankImpl(dataSetup, modelSetup.getNumMarkers());
        this.cursorTrack = new CursorTrackImpl(this, numParams, numSends, numScenes);
        dataSetup.setCursorTrack((CursorTrackImpl)this.cursorTrack);
        dataSetup.setTransport(this.transport);
        if (modelSetup.wantsClipLauncherNavigator()) {
            this.clipLauncherNavigator = new ClipLauncherNavigatorImpl(this);
        }
        this.cursorDevice = new CursorDeviceImpl(dataSetup, numSends, numParams, numListParams, numDevicesInBank, numDeviceLayers, numDrumPadLayers);
        this.focusedParameter = new FocusedParameterImpl((CursorDeviceImpl)this.cursorDevice);
        ArrayList<IDrumDevice> drumDevices = new ArrayList<IDrumDevice>();
        if (modelSetup.wantsMainDrumDevice()) {
            this.drumDevice = new DrumDeviceImpl(dataSetup, numSends, numParams, numDevicesInBank, numDeviceLayers, numDrumPadLayers);
            drumDevices.add(this.drumDevice);
            int[] additionalDrumDevicePageSizes = modelSetup.wantsAdditionalDrumDevices();
            for (Object pageSize : (Object)additionalDrumDevicePageSizes) {
                DrumDeviceImpl addDrumDevice = new DrumDeviceImpl(dataSetup, numSends, 0, 0, (int)pageSize, (int)pageSize);
                this.additionalDrumDevices.put((int)pageSize, addDrumDevice);
            }
            drumDevices.addAll(this.additionalDrumDevices.values());
        }
        this.cursorLayer = new CursorLayerImpl(numDevicesInBank, numDeviceLayers);
        CursorDeviceImpl firstInstrumentDevice = null;
        for (DeviceID deviceID : modelSetup.getDeviceIDs()) {
            switch (deviceID) {
                case FIRST_INSTRUMENT: 
                case NI_KOMPLETE: {
                    if (firstInstrumentDevice == null) {
                        firstInstrumentDevice = new CursorDeviceImpl(dataSetup, numSends, numParams, 0, numDevicesInBank, numDeviceLayers, numDrumPadLayers);
                        this.specificDevices.put(DeviceID.FIRST_INSTRUMENT, firstInstrumentDevice);
                    }
                    if (deviceID != DeviceID.NI_KOMPLETE) break;
                    this.specificDevices.put(deviceID, new KompleteDevice(firstInstrumentDevice));
                    break;
                }
                case EQ: {
                    this.specificDevices.put(deviceID, new EqualizerDeviceImpl(dataSetup, numParams));
                    break;
                }
            }
        }
        ISceneBank sceneBank = this.getSceneBank(numScenes);
        this.trackBank = new TrackBankImpl(dataSetup, (ApplicationImpl)this.application, drumDevices, numTracks, sceneBank, numScenes, numSends, numParams, modelSetup.hasFlatTrackList(), modelSetup.hasFullFlatTrackList());
        this.masterTrack = new MasterTrackImpl(dataSetup, (TrackBankImpl)this.trackBank, numSends, numParams);
        ((TrackBankImpl)this.trackBank).setMasterTrack((TrackImpl)((Object)this.masterTrack));
        this.effectTrackBank = null;
        int numResults = modelSetup.getNumResults();
        if (numResults > 0) {
            this.browser = new BrowserImpl(dataSetup, this.cursorDevice, modelSetup.getNumFilterColumnEntries(), numResults);
        }
        this.currentTrackBank = this.trackBank;
    }

    @Override
    public ISceneBank getSceneBank(int numScenes) {
        return this.sceneBanks.computeIfAbsent(numScenes, key -> new SceneBankImpl(this.dataSetup, numScenes));
    }

    @Override
    public ISlotBank getSlotBank(int numSlots) {
        return this.slotBanks.computeIfAbsent(numSlots, key -> new ResizedSlotBank(this.cursorTrack, numSlots));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INoteClip getNoteClip(int cols, int rows) {
        Map map = this.cursorClips;
        synchronized (map) {
            return this.cursorClips.computeIfAbsent(cols + "-" + rows, k -> new CursorClipImpl(this.dataSetup, cols, rows));
        }
    }

    @Override
    public void createNoteClip(ITrack track, ISlot slot, int lengthInBeats, boolean overdub) {
        track.createClip(slot.getIndex(), lengthInBeats);
        slot.select();
        if (overdub) {
            this.transport.startRecording();
        }
    }

    @Override
    public void recordNoteClip(ITrack track, ISlot slot) {
        ((TrackImpl)track).recordClip();
    }

    @Override
    public INoteClip getCursorClip() {
        if (this.cursorClips.isEmpty()) {
            throw new FrameworkException("No cursor clip created!");
        }
        return (INoteClip)this.cursorClips.values().iterator().next();
    }

    @Override
    public void ensureClip() {
        this.getNoteClip(0, 0);
    }

    @Override
    public boolean isCursorDeviceOnMasterTrack() {
        return this.getMasterTrack().isSelected();
    }

    @Override
    public boolean canConvertClip() {
        return true;
    }

    @Override
    public void cleanup() {
        if (this.clipLauncherNavigator != null) {
            ((ClipLauncherNavigatorImpl)this.clipLauncherNavigator).shutdown();
        }
    }

    @Override
    public Optional<IFocusedParameter> getFocusedParameter() {
        return Optional.of(this.focusedParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursorClipNotes(List<Note> notes) {
        Map map = this.cursorClips;
        synchronized (map) {
            for (INoteClip clip : this.cursorClips.values()) {
                ((CursorClipImpl)clip).setNotes(notes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursorClipExists(boolean exists) {
        Map map = this.cursorClips;
        synchronized (map) {
            for (INoteClip clip : this.cursorClips.values()) {
                ((CursorClipImpl)clip).setExistsValue(exists);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursorClipPlayStart(double start) {
        Map map = this.cursorClips;
        synchronized (map) {
            for (INoteClip clip : this.cursorClips.values()) {
                ((CursorClipImpl)clip).setPlayStartIntern(start);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursorClipPlayEnd(double end) {
        Map map = this.cursorClips;
        synchronized (map) {
            for (INoteClip clip : this.cursorClips.values()) {
                ((CursorClipImpl)clip).setPlayEndIntern(end);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursorClipPlayPosition(double playPosition) {
        Map map = this.cursorClips;
        synchronized (map) {
            for (INoteClip clip : this.cursorClips.values()) {
                ((CursorClipImpl)clip).setPlayPosition(playPosition);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursorClipColorValue(double[] color) {
        Map map = this.cursorClips;
        synchronized (map) {
            for (INoteClip clip : this.cursorClips.values()) {
                ((CursorClipImpl)clip).setColorValue(color);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursorClipLoopIsEnabled(boolean isLoopEnabled) {
        Map map = this.cursorClips;
        synchronized (map) {
            for (INoteClip clip : this.cursorClips.values()) {
                ((CursorClipImpl)clip).setLoopEnabledState(isLoopEnabled);
            }
        }
    }

    public void setClips(String clipsStr) {
        if (clipsStr == null) {
            return;
        }
        String[] clipParts = clipsStr.trim().split(";");
        int pos = 0;
        int maxSlotCount = 0;
        TrackBankImpl tb = (TrackBankImpl)this.trackBank;
        while (pos < clipParts.length) {
            int numClips;
            int trackIndex = Integer.parseInt(clipParts[pos++]);
            TrackImpl track = (TrackImpl)tb.getUnpagedItem(trackIndex);
            SlotBankImpl slotBank = (SlotBankImpl)track.getSlotBank();
            if ((numClips = Integer.parseInt(clipParts[pos++])) > maxSlotCount) {
                maxSlotCount = numClips;
            }
            slotBank.setItemCount(numClips);
            for (int i = 0; i < numClips; ++i) {
                String name = clipParts[pos++];
                boolean isSelected = Integer.parseInt(clipParts[pos++]) > 0;
                Optional<double[]> color = this.parseColor(clipParts[pos++]);
                boolean isMuted = Integer.parseInt(clipParts[pos++]) > 0;
                SlotImpl slot = (SlotImpl)slotBank.getUnpagedItem(i);
                slot.setPosition(i);
                slot.setSelected(isSelected);
                slot.setMuted(isMuted);
                slot.setName(name);
                if (color.isPresent()) {
                    slot.setColor(new ColorEx(color.get()));
                }
                slot.setExists(true);
                slot.setHasContent(true);
            }
        }
        int size = tb.getItemCount();
        for (int i = 0; i < size; ++i) {
            TrackImpl track = (TrackImpl)tb.getUnpagedItem(i);
            SlotBankImpl slotBank = (SlotBankImpl)track.getSlotBank();
            int itemCount = slotBank.getItemCount();
            slotBank.setMaxSlotCount(maxSlotCount);
            for (int slotIndex = itemCount; slotIndex < maxSlotCount; ++slotIndex) {
                SlotImpl slot = (SlotImpl)slotBank.getUnpagedItem(slotIndex);
                slot.setExists(true);
                slot.setHasContent(false);
            }
        }
    }

    public Optional<double[]> parseColor(String value) {
        String[] values = value.split(" ");
        if (values.length != 3) {
            this.host.error("Color: Wrong number of arguments: " + values.length);
            StringBuilder str = new StringBuilder();
            for (String value2 : values) {
                str.append(value2).append(':');
            }
            this.host.error(str.toString());
            return Optional.empty();
        }
        double d1 = Double.parseDouble(values[0]);
        if (d1 < 0.0) {
            return Optional.empty();
        }
        return Optional.of(new double[]{d1 / 255.0, Double.parseDouble(values[1]) / 255.0, Double.parseDouble(values[2]) / 255.0});
    }

    public Collection<SceneBankImpl> getSceneBanks() {
        return this.sceneBanks.values();
    }
}

