/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.parameter;

import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.parameter.AbstractParameterImpl;

public class ZoomParameter
extends AbstractParameterImpl {
    protected final IApplication application;
    protected final boolean isHorizontal;

    public ZoomParameter(IValueChanger valueChanger, IApplication application, boolean isHorizontal) {
        super(valueChanger, 0);
        this.application = application;
        this.isHorizontal = isHorizontal;
    }

    @Override
    public int getValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setValue(IValueChanger valueChanger, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNormalizedValue(double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void changeValue(IValueChanger valueChanger, int value) {
        this.inc(valueChanger.isIncrease(value) ? 1.0 : -1.0);
    }

    @Override
    public void setValueImmediatly(int value) {
        this.setValue(value);
    }

    @Override
    public void inc(double increment) {
        if (this.isHorizontal) {
            if (increment > 0.0) {
                this.application.zoomIn();
            } else {
                this.application.zoomOut();
            }
            return;
        }
        if (increment > 0.0) {
            this.application.incTrackHeight();
        } else {
            this.application.decTrackHeight();
        }
    }

    @Override
    public void resetValue() {
        this.setValue(0);
    }

    @Override
    public String getDisplayedValue() {
        return "";
    }

    @Override
    public boolean doesExist() {
        return true;
    }

    @Override
    public String getName() {
        return "Zoom In/Out";
    }
}

