/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.osc.module;

import de.mossgrabers.controller.osc.exception.IllegalParameterException;
import de.mossgrabers.controller.osc.exception.MissingCommandException;
import de.mossgrabers.controller.osc.exception.UnknownCommandException;
import de.mossgrabers.controller.osc.module.AbstractModule;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IMarker;
import de.mossgrabers.framework.daw.data.bank.IMarkerBank;
import de.mossgrabers.framework.osc.IOpenSoundControlWriter;
import java.util.LinkedList;

public class MarkerModule
extends AbstractModule {
    public MarkerModule(IHost host, IModel model, IOpenSoundControlWriter writer) {
        super(host, model, writer);
    }

    @Override
    public String[] getSupportedCommands() {
        return new String[]{"marker"};
    }

    @Override
    public void execute(String command, LinkedList<String> path, Object value) throws IllegalParameterException, UnknownCommandException, MissingCommandException {
        if (!"marker".equals(command)) {
            throw new UnknownCommandException(command);
        }
        String subCommand = MarkerModule.getSubCommand(path);
        try {
            int markerNo = Integer.parseInt(subCommand) - 1;
            String subCommand2 = MarkerModule.getSubCommand(path);
            if (!"launch".equals(subCommand2)) {
                throw new UnknownCommandException(subCommand2);
            }
            ((IMarker)this.model.getMarkerBank().getItem(markerNo)).launch(true);
        }
        catch (NumberFormatException ex) {
            IMarkerBank markerBank = this.model.getMarkerBank();
            if ("bank".equals(subCommand)) {
                String subCommand2;
                switch (subCommand2 = MarkerModule.getSubCommand(path)) {
                    case "+": {
                        markerBank.selectNextPage();
                        break;
                    }
                    case "-": {
                        markerBank.selectPreviousPage();
                        break;
                    }
                    default: {
                        throw new UnknownCommandException(subCommand2);
                    }
                }
            }
            throw new UnknownCommandException(subCommand);
        }
    }

    @Override
    public void flush(boolean dump) {
        IMarkerBank markerBank = this.model.getMarkerBank();
        for (int i = 0; i < markerBank.getPageSize(); ++i) {
            String markerAddress = "/marker/" + (i + 1) + "/";
            IMarker marker = (IMarker)markerBank.getItem(i);
            this.writer.sendOSC(markerAddress + "exists", marker.doesExist(), dump);
            this.writer.sendOSC(markerAddress + "name", marker.getName(), dump);
            ColorEx color = marker.getColor();
            this.writer.sendOSCColor(markerAddress + "color", color.getRed(), color.getGreen(), color.getBlue(), dump);
        }
    }
}

