/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.view;

import de.mossgrabers.controller.novation.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.novation.launchpad.view.PlayControls;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.IScrollableView;
import de.mossgrabers.framework.scale.Scale;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.ScrollStates;
import de.mossgrabers.framework.view.AbstractPlayView;
import de.mossgrabers.framework.view.Views;

public class PlayView
extends AbstractPlayView<LaunchpadControlSurface, LaunchpadConfiguration>
implements IScrollableView {
    private final PlayControls playControls;

    public PlayView(LaunchpadControlSurface surface, IModel model) {
        this("Play", surface, model);
    }

    public PlayView(String name, LaunchpadControlSurface surface, IModel model) {
        super(name, surface, model, true);
        this.playControls = new PlayControls(surface, this.scales);
        Object configuration = ((LaunchpadControlSurface)this.surface).getConfiguration();
        PlayView playView = this;
        configuration.addSettingObserver(AbstractConfiguration.ACTIVATE_FIXED_ACCENT, () -> playView.initMaxVelocity());
        playView = this;
        configuration.addSettingObserver(AbstractConfiguration.FIXED_ACCENT_VALUE, () -> playView.initMaxVelocity());
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return 0;
        }
        switch (buttonID) {
            case SCENE1: 
            case SCENE2: 
            case SCENE7: 
            case SCENE8: {
                return 41;
            }
            case SCENE4: {
                return this.playControls.getToggleButtonColor();
            }
            case SCENE5: {
                return 11;
            }
            case SCENE6: {
                return this.scales.isChromatic() ? 3 : 1;
            }
        }
        return 0;
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID) || event != ButtonEvent.DOWN || !this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        ITextDisplay display = ((LaunchpadControlSurface)this.surface).getTextDisplay();
        switch (buttonID) {
            case SCENE1: {
                this.scales.nextScaleLayout();
                String name = this.scales.getScaleLayout().getName();
                ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).setScaleLayout(name);
                display.notify(name);
                break;
            }
            case SCENE2: {
                this.scales.prevScaleLayout();
                String name = this.scales.getScaleLayout().getName();
                ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).setScaleLayout(name);
                display.notify(name);
                break;
            }
            case SCENE4: {
                this.playControls.toggle();
                this.setBlockedNotes(this.playControls.isActive() ? 8 : 0);
                break;
            }
            case SCENE5: {
                this.activatePreferredView(Views.CHORDS);
                display.notify("Chords: On");
                return;
            }
            case SCENE6: {
                this.scales.toggleChromatic();
                boolean isChromatic = this.scales.isChromatic();
                ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).setScaleInKey(!isChromatic);
                display.notify(isChromatic ? "Chromatic" : "In Key");
                break;
            }
            case SCENE7: {
                this.scales.setScaleOffsetByIndex(this.scales.getScaleOffsetIndex() + 1);
                String name = Scales.BASES.get(this.scales.getScaleOffsetIndex());
                ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).setScaleBase(name);
                display.notify(name);
                break;
            }
            case SCENE8: {
                this.scales.setScaleOffsetByIndex(this.scales.getScaleOffsetIndex() - 1);
                String name = Scales.BASES.get(this.scales.getScaleOffsetIndex());
                ((LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration()).setScaleBase(name);
                display.notify(name);
                break;
            }
        }
        this.updateNoteMapping();
    }

    @Override
    public void drawGrid() {
        super.drawGrid();
        this.playControls.draw();
    }

    @Override
    public void onGridNote(int key, int velocity) {
        if (!this.playControls.handleGridNotes(key, velocity)) {
            super.onGridNote(key, velocity);
        }
    }

    @Override
    public void updateScrollStates(ScrollStates scrollStates) {
        int octave = this.scales.getOctave();
        int scale = this.scales.getScale().ordinal();
        scrollStates.setCanScrollLeft(scale > 0);
        scrollStates.setCanScrollRight(scale < Scale.values().length - 1);
        scrollStates.setCanScrollUp(octave < 3);
        scrollStates.setCanScrollDown(octave > -3);
    }
}

