/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.controller;

import de.mossgrabers.controller.novation.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadPadGrid;
import de.mossgrabers.controller.novation.launchpad.definition.ILaunchpadControllerDefinition;
import de.mossgrabers.controller.novation.launchpad.view.VirtualFaderViewCallback;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.IVirtualFader;
import de.mossgrabers.framework.controller.grid.VirtualFaderImpl;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.hardware.IHwButton;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.DeviceInquiry;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.framework.view.Views;
import java.util.Map;
import java.util.Optional;

public class LaunchpadControlSurface
extends AbstractControlSurface<LaunchpadConfiguration> {
    public static final int LAUNCHPAD_BUTTON_SCENE1 = 89;
    public static final int LAUNCHPAD_BUTTON_SCENE2 = 79;
    public static final int LAUNCHPAD_BUTTON_SCENE3 = 69;
    public static final int LAUNCHPAD_BUTTON_SCENE4 = 59;
    public static final int LAUNCHPAD_BUTTON_SCENE5 = 49;
    public static final int LAUNCHPAD_BUTTON_SCENE6 = 39;
    public static final int LAUNCHPAD_BUTTON_SCENE7 = 29;
    public static final int LAUNCHPAD_BUTTON_SCENE8 = 19;
    public static final int LAUNCHPAD_FADER_1 = 21;
    public static final int LAUNCHPAD_FADER_2 = 22;
    public static final int LAUNCHPAD_FADER_3 = 23;
    public static final int LAUNCHPAD_FADER_4 = 24;
    public static final int LAUNCHPAD_FADER_5 = 25;
    public static final int LAUNCHPAD_FADER_6 = 26;
    public static final int LAUNCHPAD_FADER_7 = 27;
    public static final int LAUNCHPAD_FADER_8 = 28;
    public static final int PRO3_LAUNCHPAD_FIXED_LENGTH = 30;
    public static final int LAUNCHPAD_LOGO = 99;
    public static final int LAUNCHPAD_TRACK1 = 101;
    public static final int LAUNCHPAD_TRACK2 = 102;
    public static final int LAUNCHPAD_TRACK3 = 103;
    public static final int LAUNCHPAD_TRACK4 = 104;
    public static final int LAUNCHPAD_TRACK5 = 105;
    public static final int LAUNCHPAD_TRACK6 = 106;
    public static final int LAUNCHPAD_TRACK7 = 107;
    public static final int LAUNCHPAD_TRACK8 = 108;
    public static final int LAUNCHPAD_BUTTON_STATE_OFF = 0;
    public static final int LAUNCHPAD_BUTTON_STATE_ON = 1;
    public static final int LAUNCHPAD_BUTTON_STATE_HI = 4;
    public static final int CONTROL_MODE_OFF = 0;
    public static final int CONTROL_MODE_REC_ARM = 1;
    public static final int CONTROL_MODE_TRACK_SELECT = 2;
    public static final int CONTROL_MODE_MUTE = 3;
    public static final int CONTROL_MODE_SOLO = 4;
    public static final int CONTROL_MODE_STOP_CLIP = 5;
    private final ILaunchpadControllerDefinition definition;
    private final IVirtualFader[] virtualFaders = new IVirtualFader[8];

    public LaunchpadControlSurface(IHost host, ColorManager colorManager, LaunchpadConfiguration configuration, IMidiOutput output, IMidiInput input, ILaunchpadControllerDefinition definition) {
        super(host, configuration, colorManager, output, input, new LaunchpadPadGrid(colorManager, output, definition), definition.isPro() ? 800.0 : 680.0, definition.isPro() ? 740.0 : 670.0);
        this.definition = definition;
        for (int i = 0; i < this.virtualFaders.length; ++i) {
            this.virtualFaders[i] = new VirtualFaderImpl(host, new VirtualFaderViewCallback(i, this.viewManager), this.padGrid, i);
        }
        this.input.setSysexCallback(this::handleSysEx);
        this.output.sendSysex(DeviceInquiry.createQuery());
    }

    @Override
    protected void handleMidi(int status, int data1, int data2) {
        int code;
        if (this.getViewManager().isActive(new Views[]{Views.USER}) && ((code = status & 0xF0) == 128 || code == 144)) {
            int translated = this.padGrid.translateToGrid(data1);
            this.handleGridNote(code == 128 || data2 == 0 ? ButtonEvent.UP : ButtonEvent.DOWN, translated, data2);
            return;
        }
        super.handleMidi(status, data1, data2);
    }

    public boolean isUserPressed() {
        return this.isPressed(ButtonID.USER);
    }

    public void setLaunchpadToStandalone() {
        this.sendLaunchpadSysEx(this.definition.getStandaloneModeCommand());
    }

    public void setLaunchpadToPrgMode() {
        this.setLaunchpadMode(this.definition.getProgramModeCommand());
    }

    private void setLaunchpadMode(String data) {
        this.sendLaunchpadSysEx(data);
        for (Map.Entry<ButtonID, IHwButton> entry : this.getButtons().entrySet()) {
            ButtonID key = entry.getKey();
            int keyValue = key.ordinal();
            if (ButtonID.PAD1.ordinal() >= keyValue && ButtonID.PAD64.ordinal() <= keyValue) continue;
            entry.getValue().getLight().forceFlush();
        }
    }

    public void setupFader(int index, int color, boolean isPan) {
        this.virtualFaders[index].setup(color, isPan);
    }

    public void setFaderValue(int index, int value) {
        this.virtualFaders[index].setValue(value);
    }

    public void clearFaders() {
        for (int i = 0; i < 8; ++i) {
            this.setupFader(i, -1, false);
        }
    }

    public void moveFader(int index, int row, int velocity) {
        this.virtualFaders[index].moveTo(row, velocity);
    }

    public void updateBrightness() {
        Optional<String> brightnessSysex = this.definition.getBrightnessSysex();
        if (brightnessSysex.isEmpty()) {
            return;
        }
        int padBrightness = ((LaunchpadConfiguration)this.configuration).getPadBrightness();
        String sysexMessage = String.format(brightnessSysex.get(), padBrightness);
        this.output.sendSysex(sysexMessage);
    }

    @Override
    protected void internalShutdown() {
        this.definition.setLogoColor(this, 0);
        this.setTrigger(89, 0);
        this.setTrigger(79, 0);
        this.setTrigger(69, 0);
        this.setTrigger(59, 0);
        this.setTrigger(49, 0);
        this.setTrigger(39, 0);
        this.setTrigger(29, 0);
        this.setTrigger(19, 0);
        super.internalShutdown();
        this.definition.resetMode(this);
    }

    @Override
    public void setTrigger(BindType bindType, int channel, int cc, int state) {
        if (!(this.isPro() || cc != 89 && cc != 79 && cc != 69 && cc != 59 && cc != 49 && cc != 39 && cc != 29 && cc != 19)) {
            this.output.sendNote(cc, state);
        } else {
            this.output.sendCC(cc, state);
        }
    }

    @Override
    protected void flushHardware() {
        super.flushHardware();
        ((LaunchpadPadGrid)this.padGrid).flush();
    }

    public void sendLaunchpadSysEx(String data) {
        this.output.sendSysex(this.definition.getSysExHeader() + data + " F7");
    }

    public boolean isPro() {
        return this.definition.isPro();
    }

    public boolean hasTrackSelectionButtons() {
        return this.definition.hasTrackSelectionButtons();
    }

    private void handleSysEx(String data) {
        int[] byteData = StringUtils.fromHexStr(data);
        DeviceInquiry deviceInquiry = new DeviceInquiry(byteData);
        if (deviceInquiry.isValid()) {
            this.handleDeviceInquiryResponse(deviceInquiry);
        }
    }

    private void handleDeviceInquiryResponse(DeviceInquiry deviceInquiry) {
        int[] revisionLevel = deviceInquiry.getRevisionLevel();
        if (revisionLevel.length == 4) {
            String firmwareVersion = String.format("%d%d%d%d", revisionLevel[0], revisionLevel[1], revisionLevel[2], revisionLevel[3]);
            this.host.println("Firmware version: " + (firmwareVersion.charAt(0) == '0' ? firmwareVersion.substring(1) : firmwareVersion));
        }
    }
}

