/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.view;

import de.mossgrabers.controller.akai.fire.FireConfiguration;
import de.mossgrabers.controller.akai.fire.controller.FireControlSurface;
import de.mossgrabers.controller.akai.fire.view.IFireView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractDrum64View;

public class DrumView64
extends AbstractDrum64View<FireControlSurface, FireConfiguration>
implements IFireView {
    public DrumView64(FireControlSurface surface, IModel model) {
        super(surface, model, 16, 4);
    }

    @Override
    protected void handleButtonCombinations(int playedPad) {
        if (((FireControlSurface)this.surface).isPressed(ButtonID.SCENE3)) {
            this.handleSoloButton(playedPad);
        } else if (((FireControlSurface)this.surface).isPressed(ButtonID.SCENE4)) {
            this.handleMuteButton(playedPad);
        }
        super.handleButtonCombinations(playedPad);
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        switch (buttonID) {
            case SCENE3: {
                return ((FireControlSurface)this.surface).isPressed(ButtonID.SCENE3) ? 2 : 1;
            }
            case SCENE4: {
                return ((FireControlSurface)this.surface).isPressed(ButtonID.SCENE4) ? 2 : 1;
            }
        }
        return 0;
    }

    @Override
    public int getSoloButtonColor(int index) {
        switch (index) {
            case 2: {
                return 4;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public void onSelectKnobValue(int value) {
        if (this.model.getValueChanger().isIncrease(value)) {
            this.onOctaveUp(ButtonEvent.DOWN);
        } else {
            this.onOctaveDown(ButtonEvent.DOWN);
        }
    }
}

