/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.view;

import de.mossgrabers.controller.akai.fire.FireConfiguration;
import de.mossgrabers.controller.akai.fire.controller.FireControlSurface;
import de.mossgrabers.controller.akai.fire.mode.FireLayerMode;
import de.mossgrabers.controller.akai.fire.view.IFireView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.data.IDrumPad;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.framework.view.sequencer.AbstractDrum4View;
import java.util.Optional;

public class Drum4View
extends AbstractDrum4View<FireControlSurface, FireConfiguration>
implements IFireView {
    private boolean blockSelectKnob = false;

    public Drum4View(FireControlSurface surface, IModel model) {
        super(surface, model, 4, 4, 16, 16, true, false);
    }

    @Override
    public void onGridNoteLongPress(int note) {
        if (!this.isActive()) {
            return;
        }
        int index = note - ((FireControlSurface)this.surface).getPadGrid().getStartNote();
        ((FireControlSurface)this.surface).getButton(ButtonID.get(ButtonID.PAD1, index)).setConsumed();
        int y = index / this.clipCols;
        if (y < this.playRows) {
            return;
        }
        int stepX = index % this.clipCols;
        int stepY = this.scales.getDrumOffset() + y;
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), stepX, stepY);
        this.editNote(this.getClip(), notePosition, false);
    }

    @Override
    public int getSoloButtonColor(int index) {
        return this.isActive() && this.primary.hasDrumPads() && this.primary.getDrumPadBank().getItem(3 - index).isSelected() ? this.lanes : 0;
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        switch (buttonID) {
            case SCENE1: 
            case SCENE2: 
            case SCENE3: 
            case SCENE4: {
                IDrumPad item;
                int scene = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
                if (this.primary.hasDrumPads() && (item = this.primary.getDrumPadBank().getItem(3 - scene)).doesExist()) {
                    if (item.isSolo()) {
                        return 2;
                    }
                    return item.isMute() ? 0 : 1;
                }
                return 0;
            }
        }
        return super.getButtonColor(buttonID);
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (event != ButtonEvent.DOWN || !this.isActive()) {
            return;
        }
        INoteClip clip = this.getClip();
        if (buttonID == ButtonID.ARROW_LEFT) {
            if (((FireControlSurface)this.surface).isPressed(ButtonID.ALT)) {
                this.setResolutionIndex(this.getResolutionIndex() - 1);
            } else {
                clip.scrollStepsPageBackwards();
                this.mvHelper.notifyEditPage(clip);
            }
            return;
        }
        if (buttonID == ButtonID.ARROW_RIGHT) {
            if (((FireControlSurface)this.surface).isPressed(ButtonID.ALT)) {
                this.setResolutionIndex(this.getResolutionIndex() + 1);
            } else {
                clip.scrollStepsPageForward();
                this.mvHelper.notifyEditPage(clip);
            }
            return;
        }
        if (!ButtonID.isSceneButton(buttonID)) {
            return;
        }
        int index = 3 - (buttonID.ordinal() - ButtonID.SCENE1.ordinal());
        if (!this.primary.hasDrumPads()) {
            return;
        }
        IDrumPad item = this.primary.getDrumPadBank().getItem(index);
        if (!item.doesExist()) {
            return;
        }
        if (((FireControlSurface)this.surface).isPressed(ButtonID.SHIFT)) {
            item.toggleSolo();
            return;
        }
        if (((FireControlSurface)this.surface).isPressed(ButtonID.ALT)) {
            ((FireControlSurface)this.surface).getDisplay().notify(item.getName());
            return;
        }
        item.toggleMute();
    }

    @Override
    public void onSelectKnobValue(int value) {
        int index;
        if (!this.primary.hasDrumPads() || this.blockSelectKnob) {
            return;
        }
        boolean isUp = this.model.getValueChanger().isIncrease(value);
        IDrumPadBank drumPadBank = this.primary.getDrumPadBank();
        Optional<ILayer> sel = drumPadBank.getSelectedItem();
        int pageSize = drumPadBank.getPageSize();
        if (isUp) {
            int index2;
            int n = index2 = sel.isEmpty() ? pageSize : sel.get().getIndex() + 1;
            if (index2 == pageSize) {
                this.adjustPage(isUp, 0);
                return;
            }
            this.selectDrumPad(index2);
            return;
        }
        int n = index = sel.isEmpty() ? -1 : sel.get().getIndex() - 1;
        if (index == -1) {
            this.adjustPage(isUp, pageSize - 1);
            return;
        }
        this.selectDrumPad(index);
    }

    @Override
    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int row, int velocity, int accentVelocity) {
        if (this.isButtonCombination(ButtonID.BROWSE)) {
            if (velocity == 0) {
                ((FireControlSurface)this.surface).setTriggerConsumed(ButtonID.BROWSE);
                if (!this.primary.hasDrumPads()) {
                    return true;
                }
                IDrumPadBank drumPadBank = this.primary.getDrumPadBank();
                this.scrollPosition = drumPadBank.getScrollPosition();
                this.model.getBrowser().replace(drumPadBank.getItem(row));
            }
            return true;
        }
        boolean isUpPressed = ((FireControlSurface)this.surface).isPressed(ButtonID.ARROW_UP);
        if (isUpPressed || ((FireControlSurface)this.surface).isPressed(ButtonID.ARROW_DOWN)) {
            ((FireControlSurface)this.surface).setTriggerConsumed(isUpPressed ? ButtonID.ARROW_UP : ButtonID.ARROW_DOWN);
            if (velocity > 0) {
                this.handleSequencerAreaRepeatOperator(clip, notePosition, velocity, isUpPressed);
            }
            return true;
        }
        return super.handleSequencerAreaButtonCombinations(clip, notePosition, row, velocity, accentVelocity);
    }

    private void adjustPage(boolean isUp, int selection) {
        this.blockSelectKnob = true;
        this.changeOctave(ButtonEvent.DOWN, isUp, 4, true, true);
        ((FireControlSurface)this.surface).scheduleTask(() -> {
            this.selectDrumPad(selection);
            this.blockSelectKnob = false;
        }, 100L);
    }

    private void selectDrumPad(int index) {
        IDrumPad item = this.primary.getDrumPadBank().getItem(index);
        item.select();
        IMode activeMode = (IMode)((FireControlSurface)this.surface).getModeManager().getActive();
        if (activeMode instanceof FireLayerMode) {
            FireLayerMode fireLayerMode = (FireLayerMode)activeMode;
            fireLayerMode.parametersAdjusted();
        }
        if (item.doesExist()) {
            ((FireControlSurface)this.surface).getDisplay().notify(StringUtils.limit(item.getName(), 14));
        }
    }
}

