/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.argument.handler;

import com.illposed.osc.BytesReceiver;
import com.illposed.osc.OSCParseException;
import com.illposed.osc.OSCSerializeException;
import com.illposed.osc.argument.ArgumentHandler;
import com.illposed.osc.argument.handler.LongArgumentHandler;
import java.nio.ByteBuffer;
import java.util.Map;

public class DoubleArgumentHandler
implements ArgumentHandler<Double>,
Cloneable {
    public static final ArgumentHandler<Double> INSTANCE = new DoubleArgumentHandler();

    protected DoubleArgumentHandler() {
    }

    @Override
    public char getDefaultIdentifier() {
        return 'd';
    }

    @Override
    public Class<Double> getJavaClass() {
        return Double.class;
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
    }

    @Override
    public boolean isMarkerOnly() {
        return false;
    }

    public DoubleArgumentHandler clone() throws CloneNotSupportedException {
        return (DoubleArgumentHandler)super.clone();
    }

    @Override
    public Double parse(ByteBuffer input) throws OSCParseException {
        return Double.longBitsToDouble(LongArgumentHandler.INSTANCE.parse(input));
    }

    @Override
    public void serialize(BytesReceiver output, Double value) throws OSCSerializeException {
        LongArgumentHandler.INSTANCE.serialize(output, Double.doubleToRawLongBits(value));
    }
}

