/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc;

import com.illposed.osc.OSCBundle;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCMessageInfo;
import com.illposed.osc.OSCPacket;
import com.illposed.osc.OSCParseException;
import com.illposed.osc.argument.ArgumentHandler;
import com.illposed.osc.argument.OSCTimeTag64;
import com.illposed.osc.argument.handler.IntegerArgumentHandler;
import com.illposed.osc.argument.handler.TimeTag64ArgumentHandler;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSCParser {
    public static final int ALIGNMENT_BYTES = 4;
    public static final String BUNDLE_START = "#bundle";
    private static final byte[] BUNDLE_START_BYTES = "#bundle".getBytes(StandardCharsets.UTF_8);
    private static final String NO_ARGUMENT_TYPES = "";
    public static final byte TYPES_VALUES_SEPARATOR = 44;
    public static final char TYPE_ARRAY_BEGIN = '[';
    public static final char TYPE_ARRAY_END = ']';
    private final Logger log = LoggerFactory.getLogger(OSCParser.class);
    private final Map<Character, ArgumentHandler> identifierToType;
    private final Map<String, Object> properties;
    private final byte[] bundleStartChecker;

    public OSCParser(Map<Character, ArgumentHandler> identifierToType, Map<String, Object> properties) {
        this.identifierToType = Collections.unmodifiableMap(new HashMap<Character, ArgumentHandler>(identifierToType));
        this.properties = Collections.unmodifiableMap(new HashMap<String, Object>(properties));
        this.bundleStartChecker = new byte[BUNDLE_START.length()];
    }

    public static void align(ByteBuffer input) {
        int mod = input.position() % 4;
        int padding = (4 - mod) % 4;
        ((Buffer)input).position(input.position() + padding);
    }

    public Map<Character, ArgumentHandler> getIdentifierToTypeMapping() {
        return this.identifierToType;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public OSCPacket convert(ByteBuffer rawInput) throws OSCParseException {
        OSCPacket packet;
        ByteBuffer readOnlyInput = rawInput.asReadOnlyBuffer();
        if (this.isBundle(readOnlyInput)) {
            packet = this.convertBundle(readOnlyInput);
        } else {
            OSCMessage tmpPacket = null;
            try {
                tmpPacket = this.convertMessage(readOnlyInput);
            }
            catch (UnknownArgumentTypeParseException ex) {
                this.log.warn("Package ignored because: {}", (Object)ex.getMessage());
            }
            packet = tmpPacket;
        }
        return packet;
    }

    private boolean isBundle(ByteBuffer rawInput) {
        boolean bundle;
        int positionStart = rawInput.position();
        try {
            rawInput.get(this.bundleStartChecker);
            bundle = Arrays.equals(this.bundleStartChecker, BUNDLE_START_BYTES);
        }
        catch (BufferUnderflowException bue) {
            bundle = false;
        }
        ((Buffer)rawInput).position(positionStart);
        return bundle;
    }

    private OSCBundle convertBundle(ByteBuffer rawInput) throws OSCParseException {
        ((Buffer)rawInput).position(BUNDLE_START.length() + 1);
        OSCTimeTag64 timestamp = TimeTag64ArgumentHandler.INSTANCE.parse(rawInput);
        OSCBundle bundle = new OSCBundle(timestamp);
        while (rawInput.hasRemaining()) {
            int packetLength = IntegerArgumentHandler.INSTANCE.parse(rawInput);
            if (packetLength == 0) {
                throw new IllegalArgumentException("Packet length may not be 0");
            }
            if (packetLength % 4 != 0) {
                throw new IllegalArgumentException("Packet length has to be a multiple of 4, is:" + packetLength);
            }
            ByteBuffer packetBytes = rawInput.slice();
            ((Buffer)packetBytes).limit(packetLength);
            ((Buffer)rawInput).position(rawInput.position() + packetLength);
            OSCPacket packet = this.convert(packetBytes);
            bundle.addPacket(packet);
        }
        return bundle;
    }

    private OSCMessage convertMessage(ByteBuffer rawInput) throws OSCParseException {
        String address = this.readString(rawInput);
        CharSequence typeIdentifiers = this.readTypes(rawInput);
        ArrayList<Object> arguments = new ArrayList<Object>(typeIdentifiers.length());
        for (int ti = 0; ti < typeIdentifiers.length(); ++ti) {
            if ('[' == typeIdentifiers.charAt(ti)) {
                arguments.add(this.readArray(rawInput, typeIdentifiers, ++ti));
                while (typeIdentifiers.charAt(ti) != ']') {
                    ++ti;
                }
                continue;
            }
            arguments.add(this.readArgument(rawInput, typeIdentifiers.charAt(ti)));
        }
        try {
            return new OSCMessage(address, arguments, new OSCMessageInfo(typeIdentifiers));
        }
        catch (IllegalArgumentException ex) {
            throw new OSCParseException(ex, rawInput);
        }
    }

    private String readString(ByteBuffer rawInput) throws OSCParseException {
        return (String)this.identifierToType.get(Character.valueOf('s')).parse(rawInput);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CharSequence readTypes(ByteBuffer rawInput) throws OSCParseException {
        if (!rawInput.hasRemaining()) return NO_ARGUMENT_TYPES;
        if (rawInput.get(rawInput.position()) != 44) throw new OSCParseException("No '44' present after the address, but there is still more data left in the message", rawInput);
        rawInput.get();
        return this.readString(rawInput);
    }

    private Object readArgument(ByteBuffer rawInput, char typeIdentifier) throws OSCParseException {
        ArgumentHandler type = this.identifierToType.get(Character.valueOf(typeIdentifier));
        if (type == null) {
            throw new UnknownArgumentTypeParseException(typeIdentifier, rawInput);
        }
        Object argumentValue = type.parse(rawInput);
        return argumentValue;
    }

    private List<Object> readArray(ByteBuffer rawInput, CharSequence typeIdentifiers, int pos) throws OSCParseException {
        int arrayLen = 0;
        while (typeIdentifiers.charAt(pos + arrayLen) != ']') {
            ++arrayLen;
        }
        ArrayList<Object> array = new ArrayList<Object>(arrayLen);
        for (int ai = 0; ai < arrayLen; ++ai) {
            array.add(this.readArgument(rawInput, typeIdentifiers.charAt(pos + ai)));
        }
        return array;
    }

    private static class UnknownArgumentTypeParseException
    extends OSCParseException {
        UnknownArgumentTypeParseException(char argumentType, ByteBuffer data) {
            super("No " + ArgumentHandler.class.getSimpleName() + " registered for type '" + argumentType + "'", data);
        }
    }
}

