/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.windows;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Arrays;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.shared.SyncPoint;
import purejavahidapi.windows.HidLibrary;
import purejavahidapi.windows.Kernel32Library;
import purejavahidapi.windows.WindowsBackend;

public class HidDevice
extends purejavahidapi.HidDevice {
    private WindowsBackend m_Backend;
    private WinNT.HANDLE m_Handle;
    private int m_OutputReportLength;
    private Memory m_OutputReportMemory;
    private WinBase.OVERLAPPED m_OutputReportOverlapped;
    private int[] m_OutputReportBytesWritten;
    private int m_InputReportLength;
    private Thread m_Thread;
    private SyncPoint m_SyncStart;
    private SyncPoint m_SyncShutdown;
    private boolean m_StopThread;
    private boolean m_ForceControlOutput;
    private byte[] m_OutputReportArray;

    HidDevice(HidDeviceInfo deviceInfo, WindowsBackend backend) {
        WinNT.HANDLE handle = WindowsBackend.openDeviceHandle(deviceInfo.getPath(), false);
        if (handle == WinBase.INVALID_HANDLE_VALUE) {
            return;
        }
        this.m_Backend = backend;
        this.m_Handle = handle;
        HidLibrary.HIDD_ATTRIBUTES attrib = new HidLibrary.HIDD_ATTRIBUTES();
        attrib.Size = new NativeLong((long)attrib.size());
        HidLibrary.HidD_GetAttributes(handle, attrib);
        this.m_HidDeviceInfo = (purejavahidapi.windows.HidDeviceInfo)deviceInfo;
        HidLibrary.HIDP_PREPARSED_DATA[] ppd = new HidLibrary.HIDP_PREPARSED_DATA[1];
        boolean res = HidLibrary.HidD_GetPreparsedData(handle, ppd);
        if (!res) {
            Kernel32.INSTANCE.CloseHandle(handle);
            return;
        }
        HidLibrary.HIDP_CAPS caps = new HidLibrary.HIDP_CAPS();
        int nt_res = HidLibrary.HidP_GetCaps(ppd[0], caps);
        if (nt_res != 0x110000) {
            Kernel32.INSTANCE.CloseHandle(handle);
            return;
        }
        this.m_OutputReportLength = caps.OutputReportByteLength;
        if (this.m_OutputReportLength > 0) {
            this.m_OutputReportMemory = new Memory((long)this.m_OutputReportLength);
            this.m_OutputReportArray = new byte[this.m_OutputReportLength];
        }
        this.m_OutputReportOverlapped = new WinBase.OVERLAPPED();
        this.m_OutputReportBytesWritten = new int[1];
        this.m_InputReportLength = caps.InputReportByteLength;
        HidLibrary.HidD_FreePreparsedData(ppd[0]);
        this.m_SyncStart = new SyncPoint(2);
        this.m_SyncShutdown = new SyncPoint(2);
        this.m_Thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HidDevice.this.runReadOnBackground();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, this.m_HidDeviceInfo.getPath());
        this.m_Backend.addDevice(this.m_HidDeviceInfo.getDeviceId(), this);
        this.m_Open = true;
        if (this.m_InputReportLength > 0) {
            this.m_Thread.start();
            this.m_SyncStart.waitAndSync();
        }
        this.m_ForceControlOutput = System.getProperty("purejavahidapi.forceControlOutput") != null;
        this.m_OutputReportOverlapped.hEvent = Kernel32.INSTANCE.CreateEvent(null, true, false, null);
    }

    @Override
    public synchronized void close() {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        this.m_StopThread = true;
        if (this.m_InputReportLength > 0) {
            Kernel32Library.CancelIoEx(this.m_Handle, null);
            this.m_Thread.interrupt();
            this.m_SyncShutdown.waitAndSync();
        }
        Kernel32.INSTANCE.CloseHandle(this.m_OutputReportOverlapped.hEvent);
        Kernel32.INSTANCE.CloseHandle(this.m_Handle);
        this.m_Backend.removeDevice(this.m_HidDeviceInfo.getDeviceId());
        this.m_Open = false;
    }

    @Override
    public synchronized int setOutputReport(byte reportID, byte[] data, int length) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        if (this.m_OutputReportLength == 0) {
            throw new IllegalArgumentException("this device supports no output reports");
        }
        Arrays.fill(this.m_OutputReportArray, (byte)0);
        this.m_OutputReportArray[0] = reportID;
        System.arraycopy(data, 0, this.m_OutputReportArray, 1, length);
        if (!this.m_ForceControlOutput) {
            Kernel32.INSTANCE.ResetEvent(this.m_OutputReportOverlapped.hEvent);
            this.m_OutputReportOverlapped.Internal = null;
            this.m_OutputReportOverlapped.InternalHigh = null;
            this.m_OutputReportOverlapped.Offset = 0;
            this.m_OutputReportOverlapped.OffsetHigh = 0;
            if (!Kernel32.INSTANCE.WriteFile(this.m_Handle, this.m_OutputReportArray, this.m_OutputReportLength, null, this.m_OutputReportOverlapped) && Kernel32.INSTANCE.GetLastError() != 997) {
                return -1;
            }
            if (Kernel32.INSTANCE.WaitForSingleObject(this.m_OutputReportOverlapped.hEvent, 1000) != 0) {
                return -2;
            }
            this.m_OutputReportOverlapped.read();
            if (!Kernel32Library.GetOverlappedResult(this.m_Handle, this.m_OutputReportOverlapped, this.m_OutputReportBytesWritten, false)) {
                return -3;
            }
            return this.m_OutputReportBytesWritten[0] - 1;
        }
        this.m_OutputReportMemory.write(0L, new byte[]{reportID}, 0, 1);
        this.m_OutputReportMemory.write(1L, data, 0, length);
        if (!HidLibrary.HidD_SetOutputReport(this.m_Handle, this.m_OutputReportMemory.getByteArray(0L, length + 1), length + 1)) {
            return -4;
        }
        return length;
    }

    @Override
    public synchronized int setFeatureReport(byte reportId, byte[] data, int length) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        byte[] buffer = new byte[length + 1];
        buffer[0] = reportId;
        System.arraycopy(data, 0, buffer, 1, length);
        if (!HidLibrary.HidD_SetFeature(this.m_Handle, buffer, length + 1)) {
            return -1;
        }
        return length;
    }

    @Override
    public synchronized int setFeatureReport(byte[] data, int length) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        if (!HidLibrary.HidD_SetFeature(this.m_Handle, data, length)) {
            return -1;
        }
        return length;
    }

    @Override
    public synchronized int getFeatureReport(byte[] data, int length) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        Memory buffer = new Memory((long)data.length);
        int[] bytes = new int[1];
        WinBase.OVERLAPPED ol = new WinBase.OVERLAPPED();
        if (!Kernel32Library.DeviceIoControl(this.m_Handle, 721298, (Pointer)buffer, length, (Pointer)buffer, length, bytes, ol) && Kernel32.INSTANCE.GetLastError() != 997) {
            return -1;
        }
        if (!Kernel32Library.GetOverlappedResult(this.m_Handle, ol, bytes, true)) {
            return -1;
        }
        int n = bytes[0] + 1;
        byte[] t = buffer.getByteArray(0L, n);
        System.arraycopy(t, 0, data, 0, n);
        return n;
    }

    private void runReadOnBackground() {
        this.m_SyncStart.waitAndSync();
        int[] numBytesRead = new int[1];
        WinBase.OVERLAPPED overlapped = new WinBase.OVERLAPPED();
        overlapped.hEvent = Kernel32.INSTANCE.CreateEvent(null, true, true, null);
        Memory readBuffer = new Memory((long)this.m_InputReportLength);
        while (!this.m_StopThread) {
            Kernel32.INSTANCE.ResetEvent(overlapped.hEvent);
            numBytesRead[0] = 0;
            overlapped.Internal = null;
            overlapped.InternalHigh = null;
            overlapped.Offset = 0;
            overlapped.OffsetHigh = 0;
            if (!Kernel32Library.ReadFile(this.m_Handle, (Pointer)readBuffer, this.m_InputReportLength, numBytesRead, overlapped)) {
                if (Kernel32.INSTANCE.GetLastError() == 1167) break;
                if (Kernel32.INSTANCE.GetLastError() != 997) {
                    Kernel32Library.CancelIo(this.m_Handle);
                    System.err.println("ReadFile failed with GetLastError()==" + Kernel32.INSTANCE.GetLastError());
                }
                if (Kernel32Library.WaitForSingleObject(overlapped.hEvent, -1) != 0) {
                    System.err.println("WaitForSingleObject failed with GetLastError()==" + Kernel32.INSTANCE.GetLastError());
                }
                overlapped.read();
                if (!Kernel32Library.GetOverlappedResult(this.m_Handle, overlapped, numBytesRead, false)) {
                    if (Kernel32.INSTANCE.GetLastError() == 1167 || this.m_StopThread && Kernel32.INSTANCE.GetLastError() == 995) break;
                    System.err.println("GetOverlappedResult failed with GetLastError()==" + Kernel32.INSTANCE.GetLastError());
                }
            }
            this.processInputReport(readBuffer, numBytesRead[0]);
        }
        Kernel32.INSTANCE.CloseHandle(overlapped.hEvent);
        this.m_SyncShutdown.waitAndSync();
    }

    private void processInputReport(Memory readBuffer, int numBytesRead) {
        if (numBytesRead > 0) {
            byte reportID = readBuffer.getByte(0L);
            int len = numBytesRead - 1;
            byte[] inputReport = new byte[len];
            readBuffer.read(1L, inputReport, 0, len);
            if (this.m_InputReportListener != null) {
                this.m_InputReportListener.onInputReport(this, reportID, inputReport, len);
            }
        }
    }

    private void Log(String sMessage) {
        try {
            String fileName = "C:\\Temp\\bmx.txt";
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName, true));
            writer.write(String.valueOf(sMessage) + "\n");
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

