/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.linux;

import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import purejavahidapi.HidDevice;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.linux.CLibrary;
import purejavahidapi.linux.UdevLibrary;
import purejavahidapi.shared.Backend;

public class LinuxBackend
extends Backend {
    @Override
    public void init() {
        try {
            UdevLibrary.udev udev2 = UdevLibrary.udev_new();
            if (udev2 == null) {
                throw new Exception("udev_new returned null");
            }
            final UdevLibrary.udev_monitor udev_monitor2 = UdevLibrary.udev_monitor_new_from_netlink(udev2, "udev");
            if (udev_monitor2 == null) {
                throw new Exception("udev_monitor returned null");
            }
            if (UdevLibrary.udev_monitor_filter_add_match_subsystem_devtype(udev_monitor2, "usb", "usb_device") < 0) {
                throw new Exception("udev_monitor_filter_add_match_subsystem_devtype failed");
            }
            if (UdevLibrary.udev_monitor_enable_receiving(udev_monitor2) < 0) {
                throw new Exception("udev_monitor_enable_receiving failed");
            }
            final int udev_monitor_fd = UdevLibrary.udev_monitor_get_fd(udev_monitor2);
            Thread removalHandler = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            UdevLibrary.udev_device dev;
                            String action;
                            CLibrary.pollfd[] pfds = (CLibrary.pollfd[])new CLibrary.pollfd().toArray(1);
                            pfds[0].fd = udev_monitor_fd;
                            pfds[0].events = CLibrary.POLLIN;
                            int pollres = CLibrary.poll(pfds, 1, -1);
                            if (pollres <= 0 || !"remove".equals(action = UdevLibrary.udev_device_get_action(dev = UdevLibrary.udev_monitor_receive_device(udev_monitor2)))) continue;
                            LinuxBackend.this.deviceRemoved(UdevLibrary.udev_device_get_devnode(dev));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
            });
            removalHandler.setDaemon(true);
            removalHandler.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public List<HidDeviceInfo> enumerateDevices() {
        UdevLibrary.udev_list_entry devices;
        LinkedList<HidDeviceInfo> list = new LinkedList<HidDeviceInfo>();
        UdevLibrary.udev udev2 = UdevLibrary.udev_new();
        UdevLibrary.udev_enumerate enumerate = UdevLibrary.udev_enumerate_new(udev2);
        UdevLibrary.udev_enumerate_add_match_subsystem(enumerate, "hidraw");
        UdevLibrary.udev_enumerate_scan_devices(enumerate);
        UdevLibrary.udev_list_entry dev_list_entry = devices = UdevLibrary.udev_enumerate_get_list_entry(enumerate);
        while (dev_list_entry != null) {
            block4: {
                String sysfs_path = UdevLibrary.udev_list_entry_get_name(dev_list_entry);
                UdevLibrary.udev_device raw_dev = UdevLibrary.udev_device_new_from_syspath(udev2, sysfs_path);
                UdevLibrary.udev_device hid_dev = UdevLibrary.udev_device_get_parent_with_subsystem_devtype(raw_dev, "hid", null);
                if (hid_dev != null) {
                    try {
                        Properties p = new Properties();
                        p.load(new StringReader(UdevLibrary.udev_device_get_sysattr_value(hid_dev, "uevent")));
                        String[] hidId = ((String)p.get("HID_ID")).split(":");
                        short bus = (short)Long.parseLong(hidId[0], 16);
                        short vid = (short)Long.parseLong(hidId[1], 16);
                        short pid = (short)Long.parseLong(hidId[2], 16);
                        if (bus != 3 && bus != 5) break block4;
                        purejavahidapi.linux.HidDeviceInfo info = new purejavahidapi.linux.HidDeviceInfo(sysfs_path);
                        list.add(info);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    UdevLibrary.udev_device_unref(raw_dev);
                }
            }
            dev_list_entry = UdevLibrary.udev_list_entry_get_next(dev_list_entry);
        }
        UdevLibrary.udev_enumerate_unref(enumerate);
        UdevLibrary.udev_unref(udev2);
        return list;
    }

    @Override
    public HidDevice openDevice(HidDeviceInfo deviceInfo) throws IOException {
        return new purejavahidapi.linux.HidDevice(deviceInfo, this);
    }
}

