/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.ui.widget;

import de.mossgrabers.reaper.ui.widget.Functions;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class TitledSeparator
extends JPanel {
    private static final long serialVersionUID = 3546082445448654905L;
    protected JLabel label;
    protected JSeparator sep = new JSeparator();

    public TitledSeparator(String text) {
        super(null);
        this.add(this.sep);
        this.label = new JLabel(Functions.getText(text));
        this.add(this.label);
        Font f = this.label.getFont();
        this.label.setFont(new Font(f.getFontName(), 1, f.getSize()));
    }

    public void setLabelFor(Component c) {
        this.label.setLabelFor(c);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Font f = this.label.getFont();
        Rectangle2D bounds = f.getStringBounds(this.label.getText(), g2.getFontRenderContext());
        Dimension size = this.getSize();
        int y = size.height / 2;
        int x = (int)bounds.getWidth() + 2;
        this.sep.setBounds(x, y, size.width - x, size.height);
        this.label.setBounds(0, 0, x, size.height);
        super.paintComponent(g);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.label.getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.label.setEnabled(b);
    }
}

