/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.graphics;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGUniverse;
import de.mossgrabers.framework.graphics.IImage;
import de.mossgrabers.framework.utils.FrameworkException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SVGImage
implements IImage {
    private static final Map<Object, Object> RENDERING_HINTS = Map.of(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON, RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY, RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY, RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE, RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON, RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC, RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY, RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE, RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    private static final SVGUniverse RENDERER = new SVGUniverse();
    private static final Map<String, Map<Color, SVGImage>> CACHE = new HashMap<String, Map<Color, SVGImage>>();
    private static final Object CACHE_LOCK = new Object();
    private static final Set<String> STROKE_ELEMENTS = Set.of("polygon", "circle", "path", "rect");
    private final BufferedImage bufferedImage;
    private final String imageName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVGImage getSVGImage(String imageName, Color color) {
        Object object = CACHE_LOCK;
        synchronized (object) {
            Map images = CACHE.computeIfAbsent(imageName, in -> new HashMap());
            return images.computeIfAbsent(color, col -> {
                try {
                    return new SVGImage(imageName, color);
                }
                catch (IOException ex) {
                    throw new FrameworkException("SVG image not found.", ex);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Object object = CACHE_LOCK;
        synchronized (object) {
            CACHE.clear();
        }
    }

    public SVGImage(String imageName, Color color) throws IOException {
        this.imageName = imageName;
        try {
            SVGDiagram diagram = RENDERER.getDiagram(RENDERER.loadSVG(this.getClass().getResource(imageName)));
            SVGImage.changeColorOfElement(SVGImage.toText(color), (SVGElement)diagram.getRoot());
            this.bufferedImage = new BufferedImage((int)diagram.getWidth(), (int)diagram.getHeight(), 2);
            Graphics2D graphics = (Graphics2D)this.bufferedImage.getGraphics();
            graphics.setRenderingHints(RENDERING_HINTS);
            diagram.render(graphics);
        }
        catch (SVGException ex) {
            throw new IOException(ex);
        }
    }

    public BufferedImage getImage() {
        return this.bufferedImage;
    }

    public String getImageName() {
        return this.imageName;
    }

    private static void changeColorOfElement(String color, SVGElement node) throws SVGElementException {
        if (STROKE_ELEMENTS.contains(node.getTagName())) {
            if (node.hasAttribute("fill", 1)) {
                node.setAttribute("fill", 1, color);
            } else {
                node.addAttribute("fill", 1, color);
            }
        }
        for (int i = 0; i < node.getNumChildren(); ++i) {
            SVGImage.changeColorOfElement(color, node.getChild(i));
        }
    }

    private static final String toText(Color color) {
        return new StringBuilder(20).append("rgb(").append(color.getRed()).append(',').append(color.getGreen()).append(',').append(color.getBlue()).append(')').toString();
    }

    @Override
    public double getWidth() {
        return this.getImage().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getImage().getHeight();
    }
}

