/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw;

import java.util.ArrayList;
import java.util.List;

public class Note {
    private final boolean isSelected;
    private final boolean isMuted;
    private final double start;
    private final double end;
    private final int channel;
    private final int pitch;
    private final int velocity;

    public Note(boolean isSelected, boolean isMuted, double start, double end, int channel, int pitch, int velocity) {
        this.isSelected = isSelected;
        this.isMuted = isMuted;
        this.start = start;
        this.end = end;
        this.channel = channel;
        this.pitch = pitch;
        this.velocity = velocity;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean isMuted() {
        return this.isMuted;
    }

    public int getChannel() {
        return this.channel;
    }

    public double getStart() {
        return this.start;
    }

    public double getEnd() {
        return this.end;
    }

    public int getPitch() {
        return this.pitch;
    }

    public int getVelocity() {
        return this.velocity;
    }

    public static List<Note> parseNotes(String notesStr) {
        ArrayList<Note> notes = new ArrayList<Note>();
        if (notesStr != null) {
            for (String part : notesStr.trim().split(";")) {
                String[] noteParts = part.split(":");
                boolean isSelected = Integer.parseInt(noteParts[0]) > 0;
                boolean isMuted = Integer.parseInt(noteParts[1]) > 0;
                double start = Double.parseDouble(noteParts[2]);
                double end = Double.parseDouble(noteParts[3]);
                int channel = Integer.parseInt(noteParts[4]);
                int pitch = Integer.parseInt(noteParts[5]);
                int velocity = Integer.parseInt(noteParts[6]);
                notes.add(new Note(isSelected, isMuted, start, end, channel, pitch, velocity));
            }
        }
        return notes;
    }
}

