/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw;

import de.mossgrabers.framework.daw.data.IParameterList;
import de.mossgrabers.framework.daw.data.ISpecificDevice;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.daw.data.bank.ILayerBank;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.observer.IValueObserver;
import de.mossgrabers.reaper.framework.daw.data.SpecificDeviceImpl;

public class KompleteDevice
implements ISpecificDevice {
    private final ISpecificDevice instrumentDevice;

    public KompleteDevice(ISpecificDevice instrumentDevice) {
        this.instrumentDevice = instrumentDevice;
    }

    @Override
    public boolean doesExist() {
        String name = this.getName();
        return name.contains("Komplete Kontrol") || name.contains("Kontakt 7") || name.contains("Kontakt 8") || name.contains("Maschine 3");
    }

    @Override
    public String getID() {
        String name = this.getName();
        ISpecificDevice iSpecificDevice = this.instrumentDevice;
        if (iSpecificDevice instanceof SpecificDeviceImpl) {
            SpecificDeviceImpl deviceImpl = (SpecificDeviceImpl)iSpecificDevice;
            if (name.contains("Komplete Kontrol")) {
                return deviceImpl.getUnpagedParameterName(0);
            }
            if (name.contains("Kontakt 7") || name.contains("Kontakt 8")) {
                return deviceImpl.getUnpagedParameterName(2048);
            }
            if (name.contains("Maschine 3")) {
                return deviceImpl.getUnpagedParameterName(128);
            }
        }
        return "";
    }

    @Override
    public void remove() {
        this.instrumentDevice.remove();
    }

    @Override
    public void duplicate() {
        this.instrumentDevice.duplicate();
    }

    @Override
    public int getIndex() {
        return this.instrumentDevice.getIndex();
    }

    @Override
    public int getPosition() {
        return this.instrumentDevice.getPosition();
    }

    @Override
    public boolean isSelected() {
        return this.instrumentDevice.isSelected();
    }

    @Override
    public void setSelected(boolean isSelected) {
        this.instrumentDevice.setSelected(isSelected);
    }

    @Override
    public void select() {
        this.instrumentDevice.select();
    }

    @Override
    public void toggleMultiSelect() {
        this.instrumentDevice.toggleMultiSelect();
    }

    @Override
    public String getName() {
        return this.instrumentDevice.getName();
    }

    @Override
    public String getName(int limit) {
        return this.instrumentDevice.getName(limit);
    }

    @Override
    public void addNameObserver(IValueObserver<String> observer) {
        this.instrumentDevice.addNameObserver(observer);
    }

    @Override
    public void setName(String name) {
        this.instrumentDevice.setName(name);
    }

    @Override
    public void enableObservers(boolean enable) {
        this.instrumentDevice.enableObservers(enable);
    }

    @Override
    public boolean isEnabled() {
        return this.instrumentDevice.isEnabled();
    }

    @Override
    public void toggleEnabledState() {
        this.instrumentDevice.toggleEnabledState();
    }

    @Override
    public boolean isPlugin() {
        return this.instrumentDevice.isPlugin();
    }

    @Override
    public boolean isExpanded() {
        return this.instrumentDevice.isExpanded();
    }

    @Override
    public void toggleExpanded() {
        this.instrumentDevice.toggleExpanded();
    }

    @Override
    public boolean isParameterPageSectionVisible() {
        return this.instrumentDevice.isParameterPageSectionVisible();
    }

    @Override
    public void toggleParameterPageSectionVisible() {
        this.instrumentDevice.toggleParameterPageSectionVisible();
    }

    @Override
    public boolean isWindowOpen() {
        return this.instrumentDevice.isWindowOpen();
    }

    @Override
    public void toggleWindowOpen() {
        this.instrumentDevice.toggleWindowOpen();
    }

    @Override
    public boolean isNested() {
        return this.instrumentDevice.isNested();
    }

    @Override
    public boolean hasDrumPads() {
        return this.instrumentDevice.hasDrumPads();
    }

    @Override
    public void addHasDrumPadsObserver(IValueObserver<Boolean> observer) {
        this.instrumentDevice.addHasDrumPadsObserver(observer);
    }

    @Override
    public void removeHasDrumPadsObserver(IValueObserver<Boolean> observer) {
        this.instrumentDevice.removeHasDrumPadsObserver(observer);
    }

    @Override
    public boolean hasLayers() {
        return this.instrumentDevice.hasLayers();
    }

    @Override
    public boolean hasSlots() {
        return this.instrumentDevice.hasSlots();
    }

    @Override
    public IParameterBank getParameterBank() {
        return this.instrumentDevice.getParameterBank();
    }

    @Override
    public ILayerBank getLayerBank() {
        return this.instrumentDevice.getLayerBank();
    }

    @Override
    public IDrumPadBank getDrumPadBank() {
        return this.instrumentDevice.getDrumPadBank();
    }

    @Override
    public IParameterList getParameterList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPresetName() {
        return "";
    }
}

