/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.data.IDeviceMetadata;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameter.ZoomParameter;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.BaseImpl;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.device.DeviceMetadataImpl;
import de.mossgrabers.reaper.ui.utils.RobotUtil;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ApplicationImpl
extends BaseImpl
implements IApplication {
    private static final String[] PANEL_LAYOUTS = new String[]{"ARRANGE", "MIX", "EDIT", "PLAY"};
    private String panelLayout = "ARRANGE";
    private boolean engineActive = true;
    private int windowLayout = 0;
    private boolean canUndoState = true;
    private boolean canRedoState = true;
    private final ZoomParameter horizontalZoomParameter = new ZoomParameter(this.valueChanger, this, true);
    private final ZoomParameter verticalZoomParameter = new ZoomParameter(this.valueChanger, this, true);

    public ApplicationImpl(DataSetupEx dataSetup) {
        super(dataSetup);
    }

    @Override
    public boolean isEngineActive() {
        return this.engineActive;
    }

    @Override
    public void setEngineActive(boolean active) {
        this.sender.processBooleanArg(Processor.PROJECT, "engine", active);
    }

    @Override
    public void toggleEngineActive() {
        this.setEngineActive(!this.engineActive);
    }

    @Override
    public void setPanelLayout(String panelLayout) {
        this.panelLayout = panelLayout;
        switch (panelLayout) {
            case "ARRANGE": {
                this.windowLayout = 0;
                this.sender.invokeAction(40454);
                break;
            }
            case "MIX": {
                this.windowLayout = 1;
                this.sender.invokeAction(40455);
                break;
            }
            case "EDIT": {
                this.windowLayout = 2;
                this.sender.invokeAction(40456);
                break;
            }
            case "PLAY": {
                this.windowLayout = 3;
                this.sender.invokeAction(40457);
                break;
            }
            default: {
                this.host.println("Not a supported layout: " + panelLayout);
            }
        }
    }

    @Override
    public String getPanelLayout() {
        return this.panelLayout;
    }

    @Override
    public void previousPanelLayout() {
        this.setPanelLayout(this.windowLayout - 1);
    }

    @Override
    public void nextPanelLayout() {
        this.setPanelLayout(this.windowLayout + 1);
    }

    private void setPanelLayout(int index) {
        this.windowLayout = index % 4;
        this.panelLayout = PANEL_LAYOUTS[this.windowLayout];
        this.sender.invokeAction(40454 + this.windowLayout);
    }

    @Override
    public boolean isArrangeLayout() {
        return "ARRANGE".equals(this.panelLayout);
    }

    @Override
    public boolean isMixerLayout() {
        return "MIX".equals(this.panelLayout);
    }

    @Override
    public boolean isEditLayout() {
        return "EDIT".equals(this.panelLayout);
    }

    @Override
    public boolean isPlayLayout() {
        return "PLAY".equals(this.panelLayout);
    }

    @Override
    public void toggleNoteEditor() {
        this.sender.invokeAction(40716);
    }

    @Override
    public void toggleAutomationEditor() {
        this.sender.invokeAction(40926);
    }

    @Override
    public void toggleDevices() {
    }

    @Override
    public void toggleInspector() {
        this.sender.invokeAction(40906);
    }

    @Override
    public void toggleMixer() {
        this.sender.invokeAction(40078);
    }

    @Override
    public void toggleFullScreen() {
        this.sender.invokeAction(40346);
    }

    @Override
    public void toggleBrowserVisibility() {
        this.sender.invokeAction(50124);
    }

    @Override
    public void duplicate() {
    }

    @Override
    public void deleteSelection() {
        this.sender.invokeAction(40006);
    }

    @Override
    public void undo() {
        this.sender.processNoArg(Processor.UNDO);
    }

    @Override
    public boolean canUndo() {
        return this.canUndoState;
    }

    public void setCanUndoState(boolean canUndoState) {
        this.canUndoState = canUndoState;
    }

    @Override
    public void redo() {
        this.sender.processNoArg(Processor.REDO);
    }

    @Override
    public boolean canRedo() {
        return this.canRedoState;
    }

    public void setCanRedoState(boolean canRedoState) {
        this.canRedoState = canRedoState;
    }

    @Override
    public void addAudioTrack() {
        this.addChannel(ChannelType.AUDIO, null, null, Collections.emptyList());
    }

    @Override
    public void addEffectTrack() {
        this.addChannel(ChannelType.EFFECT, null, null, Collections.emptyList());
    }

    @Override
    public void addInstrumentTrack() {
        this.addChannel(ChannelType.INSTRUMENT, null, null, Collections.emptyList());
    }

    public void addChannel(ChannelType type, String name, ColorEx color, List<IDeviceMetadata> devices) {
        Object colorTxt;
        ArrayList<String> params = new ArrayList<String>();
        params.add(switch (type) {
            case ChannelType.HYBRID, ChannelType.INSTRUMENT -> "INSTRUMENT";
            case ChannelType.EFFECT -> "EFFECT";
            default -> "AUDIO";
        });
        params.add(name == null ? "" : name);
        if (color == null) {
            colorTxt = "";
        } else {
            int[] rgb = color.toIntRGB255();
            colorTxt = "RGB(" + rgb[0] + "," + rgb[1] + "," + rgb[2] + ")";
        }
        params.add((String)colorTxt);
        for (IDeviceMetadata device : devices) {
            params.add(((DeviceMetadataImpl)device).getCreationName());
        }
        this.sender.processStringArgs(Processor.TRACK, "addTrack", params.toArray(new String[params.size()]));
    }

    @Override
    public void arrowKeyLeft() {
        this.sender.invokeAction(40286);
    }

    @Override
    public void arrowKeyUp() {
        this.sender.invokeAction(40286);
    }

    @Override
    public void arrowKeyRight() {
        this.sender.invokeAction(40285);
    }

    @Override
    public void arrowKeyDown() {
        this.sender.invokeAction(40285);
    }

    @Override
    public void zoomOut() {
        this.sender.invokeAction(1011);
    }

    @Override
    public void zoomIn() {
        this.sender.invokeAction(1012);
    }

    @Override
    public IParameter getZoomParameter() {
        return this.horizontalZoomParameter;
    }

    @Override
    public void decTrackHeight() {
        this.sender.invokeAction(40112);
    }

    @Override
    public void incTrackHeight() {
        this.sender.invokeAction(40111);
    }

    @Override
    public IParameter getTrackHeightParameter() {
        return this.verticalZoomParameter;
    }

    @Override
    public void enter() {
        this.sendKey(10);
    }

    @Override
    public void escape() {
        this.sendKey(27);
    }

    @Override
    public void sliceToSampler() {
        this.invokeAction(40760);
    }

    @Override
    public void sliceToDrumMachine() {
        this.invokeAction(40760);
    }

    @Override
    public void invokeAction(String id) {
        this.sendOSC("", id);
    }

    @Override
    public void showHelp() {
        File file;
        Desktop desktop = Desktop.getDesktop();
        if (desktop.isSupported(Desktop.Action.OPEN) && (file = new File("./docs/DrivenByMoss-Manual.pdf")).exists()) {
            try {
                desktop.open(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected Processor getProcessor() {
        return Processor.ACTION;
    }

    public void setInternalEngineActive(boolean active) {
        this.engineActive = active;
    }

    private void sendKey(int key) {
        if (RobotUtil.exists()) {
            RobotUtil.sendKey(key);
        } else {
            this.host.println("Sending key presses not supported on this platform.");
        }
    }
}

