/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.configuration;

import de.mossgrabers.framework.configuration.IBooleanSetting;
import de.mossgrabers.reaper.framework.configuration.BaseValueSetting;
import de.mossgrabers.reaper.ui.utils.LogModel;
import de.mossgrabers.reaper.ui.utils.PropertiesEx;
import de.mossgrabers.reaper.ui.utils.SafeRunLater;
import javax.swing.JCheckBox;

public class BooleanSettingImpl
extends BaseValueSetting<JCheckBox, Boolean>
implements IBooleanSetting {
    private final boolean initialValue;
    private boolean value;

    public BooleanSettingImpl(LogModel logModel, PropertiesEx properties, String label, String category, boolean initialValue) {
        super(logModel, label, category, new JCheckBox());
        this.initialValue = initialValue;
        this.load(properties);
        ((JCheckBox)this.field).addActionListener(event -> SafeRunLater.execute(this.logModel, () -> this.set(((JCheckBox)this.field).isSelected())));
    }

    @Override
    public void set(Boolean value) {
        this.set((boolean)value);
    }

    @Override
    public void set(boolean value) {
        this.value = value;
        this.setDirty();
        this.flush();
        SafeRunLater.execute(this.logModel, () -> {
            boolean v = ((JCheckBox)this.field).isSelected();
            if (v != this.value) {
                ((JCheckBox)this.field).setSelected(this.value);
            }
        });
    }

    @Override
    public Boolean get() {
        return this.value;
    }

    @Override
    public void flush() {
        this.notifyObservers(this.value);
    }

    @Override
    public void store(PropertiesEx properties) {
        properties.put(this.getID(), Boolean.toString(this.value));
    }

    @Override
    public void load(PropertiesEx properties) {
        this.set(properties.getBoolean(this.getID(), this.initialValue));
    }

    @Override
    public void reset() {
        this.set(this.initialValue);
    }
}

