/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.graphics.canvas.component;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.graphics.Align;
import de.mossgrabers.framework.graphics.IGraphicsConfiguration;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.graphics.IGraphicsDimensions;
import de.mossgrabers.framework.graphics.IGraphicsInfo;
import de.mossgrabers.framework.graphics.canvas.component.ChannelSelectComponent;
import java.util.Arrays;
import java.util.List;

public class SceneListGridElement
extends ChannelSelectComponent {
    private final ColorEx[] colors;
    private final String[] names;
    private final boolean[] exists;
    private final boolean[] isSelecteds;

    public SceneListGridElement(List<IScene> scenes, ChannelType type, String name, ColorEx color, boolean isSelected, boolean isActive, boolean isPinned) {
        super(type, null, false, name, color, isSelected, isActive, isPinned);
        int size = scenes.size();
        this.colors = new ColorEx[size];
        this.names = new String[size];
        this.exists = new boolean[size];
        this.isSelecteds = new boolean[size];
        for (int i = 0; i < size; ++i) {
            IScene scene = scenes.get(i);
            this.colors[i] = scene.getColor();
            this.names[i] = scene.getName();
            this.exists[i] = scene.doesExist();
            this.isSelecteds[i] = scene.isSelected();
        }
    }

    @Override
    public void draw(IGraphicsInfo info) {
        super.draw(info);
        IGraphicsContext gc = info.getContext();
        IGraphicsDimensions dimensions = info.getDimensions();
        IGraphicsConfiguration configuration = info.getConfiguration();
        double left = info.getBounds().left();
        double width = info.getBounds().width();
        double height = info.getBounds().height();
        double separatorSize = dimensions.getSeparatorSize();
        double inset = dimensions.getInset();
        int size = this.colors.length;
        double itemLeft = left + separatorSize;
        double itemWidth = width - separatorSize;
        double itemHeight = height / (double)(size + 1);
        ColorEx textColor = configuration.getColorText();
        ColorEx borderColor = configuration.getColorBackgroundLighter();
        double fontHeight = itemHeight > 30.0 ? itemHeight / 2.0 : itemHeight * 2.0 / 3.0;
        for (int i = 0; i < size; ++i) {
            double itemTop = (double)i * itemHeight;
            ColorEx backgroundColor = this.colors[i];
            gc.fillRectangle(itemLeft, itemTop + separatorSize, itemWidth, itemHeight - 2.0 * separatorSize, backgroundColor);
            if (this.exists[i]) {
                gc.drawTextInBounds(this.names[i], itemLeft + inset, itemTop - 1.0, itemWidth - 2.0 * inset, itemHeight, Align.LEFT, ColorEx.calcContrastColor(backgroundColor), fontHeight);
            }
            gc.strokeRectangle(itemLeft, itemTop + separatorSize, itemWidth, itemHeight - 2.0 * separatorSize, this.isSelecteds[i] ? textColor : borderColor, this.isSelecteds[i] ? 2.0 : 1.0);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.colors);
        result = 31 * result + Arrays.hashCode(this.exists);
        result = 31 * result + Arrays.hashCode(this.isSelecteds);
        result = 31 * result + Arrays.hashCode(this.names);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SceneListGridElement other = (SceneListGridElement)obj;
        if (!(Arrays.equals(this.colors, other.colors) && Arrays.equals(this.exists, other.exists) && Arrays.equals(this.isSelecteds, other.isSelecteds))) {
            return false;
        }
        return Arrays.equals(this.names, other.names);
    }
}

