/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.daw;

import de.mossgrabers.framework.controller.color.ColorEx;
import java.util.List;

public enum DAWColor {
    COLOR_OFF("Off", new ColorEx(0.5, 0.5, 0.5)),
    DAW_COLOR_DARK_GRAY("Dark Gray", new ColorEx(0.3294117748737335, 0.3294117748737335, 0.3294117748737335)),
    DAW_COLOR_GRAY("Gray", new ColorEx(0.47843137383461, 0.47843137383461, 0.47843137383461)),
    DAW_COLOR_GRAY_HALF("Gray half", new ColorEx(0.5, 0.5, 0.5)),
    DAW_COLOR_LIGHT_GRAY("Light Gray", new ColorEx(0.7882353067398071, 0.7882353067398071, 0.7882353067398071)),
    DAW_COLOR_SILVER("Silver", new ColorEx(0.5254902243614197, 0.5372549295425415, 0.6745098233222961)),
    DAW_COLOR_DARK_BROWN("Dark Brown", new ColorEx(0.6392157077789307, 0.4745098054409027, (double)0.2627451f)),
    DAW_COLOR_BROWN("Brown", new ColorEx(0.7764706015586853, 0.6235294342041016, (double)0.4392157f)),
    DAW_COLOR_DARK_BLUE("Dark Blue", new ColorEx(0.34117648005485535, 0.3803921639919281, 0.7764706015586853)),
    DAW_COLOR_PURPLE_BLUE("Purplish Blue", new ColorEx(0.5176470875740051, 0.5411764979362488, 0.8784313797950745)),
    DAW_COLOR_PURPLE("Purple", new ColorEx(0.5843137502670288, 0.2862745225429535, 0.7960784435272217)),
    DAW_COLOR_PINK("Pink", new ColorEx(0.8509804010391235, 0.21960784494876862, 0.4431372582912445)),
    DAW_COLOR_RED("Red", new ColorEx(0.8509804010391235, 0.18039216101169586, 0.1411764770746231)),
    DAW_COLOR_ORANGE("Orange", new ColorEx(1.0, 0.34117648005485535, 0.0235294122248888)),
    DAW_COLOR_LIGHT_ORANGE("Light Orange", new ColorEx(0.8509804010391235, 0.615686297416687, 0.062745101749897)),
    DAW_COLOR_MOSS_GREEN("Moss Green", new ColorEx((double)0.2627451f, 0.8235294222831726, 0.7254902124404907)),
    DAW_COLOR_GREEN("Green", new ColorEx((double)0.4509804f, 0.5960784554481506, 0.0784313753247261)),
    DAW_COLOR_COLD_GREEN("Cold Green", new ColorEx(0.0, 0.615686297416687, (double)0.2784314f)),
    DAW_COLOR_BLUE("Blue", new ColorEx(0.2666666805744171, 0.7843137383460999, 1.0)),
    DAW_COLOR_LIGHT_PURPLE("Light Purple", new ColorEx(0.7372549176216125, 0.4627451002597809, 0.9411764740943909)),
    DAW_COLOR_LIGHT_PINK("Light Pink", new ColorEx(0.8823529481887817, (double)0.4f, 0.5686274766921997)),
    DAW_COLOR_ROSE("Rose", new ColorEx(0.9254902005195618, 0.3803921639919281, 0.34117648005485535)),
    DAW_COLOR_REDDISH_BROWN("Redish Brown", new ColorEx(1.0, 0.5137255191802979, 0.24313725531101227)),
    DAW_COLOR_LIGHT_BROWN("Light Brown", new ColorEx(0.8941176533699036, 0.7176470756530762, 0.30588236451148987)),
    DAW_COLOR_LIGHT_GREEN("Light Green", new ColorEx((double)0.627451f, 0.7529411911964417, 0.2980392277240753)),
    DAW_COLOR_BLUISH_GREEN("Bluish Green", new ColorEx(0.0, 0.6509804129600525, 0.5803921818733215)),
    DAW_COLOR_GREEN_BLUE("Greenish Blue", new ColorEx(0.24313725531101227, 0.7333333492279053, 0.3843137323856354)),
    DAW_COLOR_LIGHT_BLUE("Light Blue", new ColorEx(0.0, (double)0.6f, 0.8509804010391235));

    private static final List<DAWColor> NEW_TRACK_COLORS;
    private static DAWColor newTrackColor;
    private final String name;
    private final ColorEx color;

    private DAWColor(String name, ColorEx color) {
        this.name = name;
        this.color = color;
    }

    public String getName() {
        return this.name;
    }

    public ColorEx getColor() {
        return this.color;
    }

    public static ColorEx getColorEntry(String colorId) {
        DAWColor value = DAWColor.valueOf(colorId);
        return value == null ? COLOR_OFF.getColor() : value.getColor();
    }

    public static ColorEx getColorEntry(int colorIndex) {
        DAWColor[] values = DAWColor.values();
        return values[colorIndex >= 0 && colorIndex < values.length ? colorIndex : 0].getColor();
    }

    public static String getColorID(double[] rgb) {
        return DAWColor.getColorID(rgb[0], rgb[1], rgb[2]);
    }

    public static String getColorID(double red, double green, double blue) {
        return DAWColor.getColorID(new ColorEx(red, green, blue));
    }

    public static String getColorID(ColorEx color) {
        DAWColor[] values = DAWColor.values();
        DAWColor cid = values[0];
        double minError = 5.0;
        for (int i = 1; i < values.length; ++i) {
            double error = ColorEx.calcDistance(values[i].getColor(), color, true);
            if (!(error < minError)) continue;
            cid = values[i];
            minError = error;
        }
        return cid.name();
    }

    public static DAWColor getNextColor() {
        DAWColor color = newTrackColor;
        int position = NEW_TRACK_COLORS.indexOf((Object)color) + 1;
        if (position >= NEW_TRACK_COLORS.size()) {
            position = 0;
        }
        newTrackColor = NEW_TRACK_COLORS.get(position);
        return color;
    }

    static {
        NEW_TRACK_COLORS = List.of(DAW_COLOR_PURPLE, DAW_COLOR_PINK, DAW_COLOR_RED, DAW_COLOR_ORANGE, DAW_COLOR_LIGHT_ORANGE, DAW_COLOR_MOSS_GREEN, DAW_COLOR_GREEN, DAW_COLOR_COLD_GREEN, DAW_COLOR_BLUE);
        newTrackColor = DAW_COLOR_DARK_BLUE;
    }
}

