/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.controller.grid;

import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.controller.grid.LightInfo;
import de.mossgrabers.framework.daw.midi.IMidiOutput;

public class PadGridImpl
implements IPadGrid {
    protected static final int NUM_NOTES = 128;
    protected final IMidiOutput output;
    protected final ColorManager colorManager;
    protected LightInfo[] padStates;
    protected int rows;
    protected int columns;
    protected int startNote;
    protected int endNote;

    public PadGridImpl(ColorManager colorManager, IMidiOutput output) {
        this(colorManager, output, 8, 8, 36);
    }

    public PadGridImpl(ColorManager colorManager, IMidiOutput output, int rows, int columns, int startNote) {
        this.colorManager = colorManager;
        this.output = output;
        this.rows = rows;
        this.columns = columns;
        this.startNote = startNote;
        this.endNote = this.startNote + this.rows * this.columns - 1;
        this.padStates = new LightInfo[128];
        for (int i = 0; i < 128; ++i) {
            this.padStates[i] = new LightInfo();
        }
    }

    @Override
    public void light(int note, int color) {
        this.setLight(note, color, -1, false);
    }

    @Override
    public void light(int note, int color, int blinkColor, boolean fast) {
        this.setLight(note, color, blinkColor, fast);
    }

    @Override
    public void lightEx(int x, int y, int color) {
        this.lightEx(x, y, color, -1, false);
    }

    @Override
    public void lightEx(int x, int y, int color, int blinkColor, boolean fast) {
        int off = (this.rows - 1) * this.columns + this.startNote;
        this.setLight(off + x - this.columns * y, color, blinkColor, fast);
    }

    @Override
    public void light(int note, String colorID) {
        this.light(note, colorID, null, false);
    }

    @Override
    public void lightEx(int x, int y, String colorID) {
        this.lightEx(x, y, colorID, null, false);
    }

    @Override
    public void light(int note, String colorID, String blinkColorID, boolean fast) {
        this.light(note, this.colorManager.getColorIndex(colorID), blinkColorID == null ? -1 : this.colorManager.getColorIndex(blinkColorID), fast);
    }

    @Override
    public void lightEx(int x, int y, String colorID, String blinkColorID, boolean fast) {
        this.lightEx(x, y, this.colorManager.getColorIndex(colorID), blinkColorID == null ? -1 : this.colorManager.getColorIndex(blinkColorID), fast);
    }

    protected void setLight(int note, int color, int blinkColor, boolean fast) {
        this.padStates[note].setColors(color, blinkColor >= 0 ? blinkColor : this.colorManager.getColorIndex("GRID_COLOR_OFF"), fast);
    }

    @Override
    public void forceFlush(int note) {
        this.padStates[note].setColors(0, 0, false);
    }

    @Override
    public void forceFlush() {
        for (int i = this.startNote; i <= this.endNote; ++i) {
            this.padStates[i].setColors(0, 0, false);
        }
    }

    @Override
    public LightInfo getLightInfo(int note) {
        return this.padStates[note];
    }

    @Override
    public void sendState(int note) {
        LightInfo state = note < this.padStates.length ? this.padStates[note] : new LightInfo();
        int[] translated = this.translateToController(note);
        int color = state.getColor();
        int channel = translated[0] < 0 ? 0 : translated[0];
        this.sendNoteState(channel, translated[1], color < 0 ? 0 : color);
        int blinkColor = state.getBlinkColor();
        if (blinkColor > 0 && blinkColor < 128) {
            this.sendBlinkState(channel, translated[1], blinkColor, state.isFast());
        }
    }

    protected void sendNoteState(int channel, int note, int color) {
        this.output.sendNoteEx(channel, note, color);
    }

    protected void sendBlinkState(int channel, int note, int blinkColor, boolean fast) {
        this.output.sendNoteEx(fast ? 14 : 10, note, blinkColor);
    }

    @Override
    public void turnOff() {
        int color = this.colorManager.getColorIndex("GRID_COLOR_OFF");
        for (int i = this.startNote; i <= this.endNote; ++i) {
            this.light(i, color, -1, false);
            this.sendState(i);
        }
    }

    @Override
    public int translateToGrid(int note) {
        return note;
    }

    @Override
    public int[] translateToController(int note) {
        return new int[]{0, note};
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    @Override
    public int getCols() {
        return this.columns;
    }

    @Override
    public int getStartNote() {
        return this.startNote;
    }
}

