/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.mode;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.command.trigger.Direction;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.ScrollStates;
import java.util.function.BooleanSupplier;

public class ModeCursorCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    protected Direction direction;
    protected final ScrollStates scrollStates = new ScrollStates();
    protected final boolean notifySelection;
    protected final BooleanSupplier alternateMode;
    protected ButtonEvent triggerEvent = ButtonEvent.DOWN;
    protected boolean isFlipped;

    public ModeCursorCommand(Direction direction, IModel model, S surface) {
        this(direction, model, surface, true);
    }

    public ModeCursorCommand(Direction direction, IModel model, S surface, boolean notifySelection) {
        this(direction, model, surface, notifySelection, null);
    }

    public ModeCursorCommand(Direction direction, IModel model, S surface, boolean notifySelection, boolean isFlipped) {
        this(direction, model, surface, notifySelection, null);
        this.isFlipped = isFlipped;
    }

    public ModeCursorCommand(Direction direction, IModel model, S surface, boolean notifySelection, BooleanSupplier alternateMode) {
        super(model, surface);
        this.direction = direction;
        this.notifySelection = notifySelection;
        this.alternateMode = alternateMode == null ? () -> false : alternateMode;
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        IMode activeMode;
        if (event != this.getTriggerEvent()) {
            return;
        }
        switch (this.direction) {
            case LEFT: {
                if (this.alternateMode.getAsBoolean()) {
                    this.scrollDown();
                    break;
                }
                this.scrollLeft();
                break;
            }
            case RIGHT: {
                if (this.alternateMode.getAsBoolean()) {
                    this.scrollUp();
                    break;
                }
                this.scrollRight();
                break;
            }
            case UP: {
                this.scrollUp();
                break;
            }
            case DOWN: {
                this.scrollDown();
            }
        }
        if (this.notifySelection && (activeMode = (IMode)this.surface.getModeManager().getActive()) != null) {
            this.mvHelper.notifySelectedItem(activeMode);
        }
    }

    public boolean canScroll() {
        this.updateArrowStates();
        return this.scrollStates.canScroll(this.direction);
    }

    protected void updateArrowStates() {
        this.scrollStates.setCanScrollLeft(this.canSelectItemOrPage(false, false));
        this.scrollStates.setCanScrollRight(this.canSelectItemOrPage(false, true));
        this.scrollStates.setCanScrollDown(this.canSelectItemOrPage(true, false));
        this.scrollStates.setCanScrollUp(this.canSelectItemOrPage(true, true));
    }

    protected void scrollLeft() {
        this.selectItemOrPage(false, false);
    }

    protected void scrollRight() {
        this.selectItemOrPage(false, true);
    }

    protected void scrollUp() {
        this.selectItemOrPage(true, true);
    }

    protected void scrollDown() {
        this.selectItemOrPage(true, false);
    }

    protected void selectItemOrPage(boolean isPage, boolean isNext) {
        IMode activeMode = (IMode)this.surface.getModeManager().getActive();
        if (activeMode == null) {
            return;
        }
        if (isPage ^ this.isFlipped) {
            if (isNext) {
                activeMode.selectNextItemPage();
            } else {
                activeMode.selectPreviousItemPage();
            }
            return;
        }
        if (isNext) {
            activeMode.selectNextItem();
        } else {
            activeMode.selectPreviousItem();
        }
    }

    protected boolean canSelectItemOrPage(boolean isPage, boolean isNext) {
        IMode activeMode = (IMode)this.surface.getModeManager().getActive();
        if (activeMode == null) {
            return false;
        }
        if (isPage ^ this.isFlipped) {
            return isNext ? activeMode.hasNextItemPage() : activeMode.hasPreviousItemPage();
        }
        return isNext ? activeMode.hasNextItem() : activeMode.hasPreviousItem();
    }

    protected ButtonEvent getTriggerEvent() {
        return this.triggerEvent;
    }
}

