/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.yaeltex.turn.controller;

import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.parameter.NoteAttribute;
import java.util.EnumMap;
import java.util.Map;

public class YaeltexTurnColorManager
extends ColorManager {
    private static final ColorEx[] COLOR_TABLE = new ColorEx[]{ColorEx.fromRGB(0, 0, 0), ColorEx.fromRGB(242, 12, 12), ColorEx.fromRGB(242, 88, 88), ColorEx.fromRGB(242, 165, 165), ColorEx.fromRGB(242, 44, 12), ColorEx.fromRGB(242, 110, 88), ColorEx.fromRGB(242, 176, 165), ColorEx.fromRGB(242, 77, 12), ColorEx.fromRGB(242, 132, 88), ColorEx.fromRGB(242, 187, 165), ColorEx.fromRGB(242, 110, 12), ColorEx.fromRGB(242, 154, 88), ColorEx.fromRGB(242, 198, 165), ColorEx.fromRGB(242, 143, 12), ColorEx.fromRGB(242, 176, 88), ColorEx.fromRGB(242, 209, 165), ColorEx.fromRGB(242, 176, 12), ColorEx.fromRGB(242, 198, 88), ColorEx.fromRGB(242, 220, 165), ColorEx.fromRGB(242, 209, 12), ColorEx.fromRGB(242, 220, 88), ColorEx.fromRGB(242, 231, 165), ColorEx.fromRGB(242, 242, 12), ColorEx.fromRGB(242, 242, 88), ColorEx.fromRGB(242, 242, 165), ColorEx.fromRGB(209, 242, 12), ColorEx.fromRGB(220, 242, 88), ColorEx.fromRGB(209, 242, 165), ColorEx.fromRGB(176, 242, 12), ColorEx.fromRGB(198, 242, 88), ColorEx.fromRGB(176, 242, 165), ColorEx.fromRGB(143, 242, 12), ColorEx.fromRGB(176, 242, 88), ColorEx.fromRGB(143, 242, 165), ColorEx.fromRGB(110, 242, 12), ColorEx.fromRGB(154, 242, 88), ColorEx.fromRGB(110, 242, 165), ColorEx.fromRGB(77, 242, 12), ColorEx.fromRGB(132, 242, 88), ColorEx.fromRGB(77, 242, 165), ColorEx.fromRGB(44, 242, 12), ColorEx.fromRGB(110, 242, 88), ColorEx.fromRGB(44, 242, 165), ColorEx.fromRGB(12, 242, 12), ColorEx.fromRGB(88, 242, 88), ColorEx.fromRGB(12, 242, 165), ColorEx.fromRGB(12, 242, 44), ColorEx.fromRGB(88, 242, 110), ColorEx.fromRGB(12, 242, 176), ColorEx.fromRGB(12, 242, 77), ColorEx.fromRGB(88, 242, 132), ColorEx.fromRGB(12, 242, 187), ColorEx.fromRGB(12, 242, 110), ColorEx.fromRGB(88, 242, 154), ColorEx.fromRGB(12, 242, 198), ColorEx.fromRGB(12, 242, 143), ColorEx.fromRGB(88, 242, 176), ColorEx.fromRGB(12, 242, 209), ColorEx.fromRGB(12, 242, 176), ColorEx.fromRGB(88, 242, 198), ColorEx.fromRGB(12, 242, 220), ColorEx.fromRGB(12, 242, 209), ColorEx.fromRGB(88, 242, 220), ColorEx.fromRGB(12, 242, 231), ColorEx.fromRGB(12, 242, 242), ColorEx.fromRGB(88, 242, 242), ColorEx.fromRGB(12, 242, 242), ColorEx.fromRGB(12, 209, 242), ColorEx.fromRGB(88, 220, 242), ColorEx.fromRGB(12, 231, 242), ColorEx.fromRGB(12, 176, 242), ColorEx.fromRGB(88, 198, 242), ColorEx.fromRGB(12, 220, 242), ColorEx.fromRGB(12, 143, 242), ColorEx.fromRGB(88, 176, 242), ColorEx.fromRGB(12, 209, 242), ColorEx.fromRGB(12, 110, 242), ColorEx.fromRGB(88, 154, 242), ColorEx.fromRGB(12, 198, 242), ColorEx.fromRGB(12, 77, 242), ColorEx.fromRGB(88, 132, 242), ColorEx.fromRGB(12, 187, 242), ColorEx.fromRGB(12, 44, 242), ColorEx.fromRGB(88, 110, 242), ColorEx.fromRGB(12, 176, 242), ColorEx.fromRGB(12, 12, 242), ColorEx.fromRGB(88, 88, 242), ColorEx.fromRGB(12, 165, 242), ColorEx.fromRGB(44, 12, 242), ColorEx.fromRGB(110, 88, 242), ColorEx.fromRGB(44, 165, 242), ColorEx.fromRGB(77, 12, 242), ColorEx.fromRGB(132, 88, 242), ColorEx.fromRGB(77, 165, 242), ColorEx.fromRGB(110, 12, 242), ColorEx.fromRGB(154, 88, 242), ColorEx.fromRGB(110, 165, 242), ColorEx.fromRGB(143, 12, 242), ColorEx.fromRGB(176, 88, 242), ColorEx.fromRGB(143, 165, 242), ColorEx.fromRGB(176, 12, 242), ColorEx.fromRGB(198, 88, 242), ColorEx.fromRGB(176, 165, 242), ColorEx.fromRGB(209, 12, 242), ColorEx.fromRGB(220, 88, 242), ColorEx.fromRGB(209, 165, 242), ColorEx.fromRGB(242, 12, 242), ColorEx.fromRGB(242, 88, 242), ColorEx.fromRGB(242, 165, 242), ColorEx.fromRGB(242, 12, 209), ColorEx.fromRGB(242, 88, 220), ColorEx.fromRGB(242, 165, 231), ColorEx.fromRGB(242, 12, 176), ColorEx.fromRGB(242, 88, 198), ColorEx.fromRGB(242, 165, 220), ColorEx.fromRGB(242, 12, 143), ColorEx.fromRGB(242, 88, 176), ColorEx.fromRGB(242, 165, 209), ColorEx.fromRGB(242, 12, 110), ColorEx.fromRGB(242, 88, 154), ColorEx.fromRGB(242, 165, 198), ColorEx.fromRGB(242, 12, 77), ColorEx.fromRGB(242, 88, 132), ColorEx.fromRGB(242, 165, 187), ColorEx.fromRGB(242, 12, 44), ColorEx.fromRGB(242, 88, 110), ColorEx.fromRGB(242, 165, 176), ColorEx.fromRGB(240, 240, 240)};
    public static final int BLACK = 0;
    public static final int WHITE = 127;
    public static final int LIGHT_GRAY = YaeltexTurnColorManager.getIndexFor(ColorEx.LIGHT_GRAY);
    public static final int GRAY = YaeltexTurnColorManager.getIndexFor(ColorEx.GRAY);
    public static final int DARK_GRAY = 12;
    public static final int RED = 1;
    public static final int DARK_RED = YaeltexTurnColorManager.getIndexFor(ColorEx.DARK_RED);
    public static final int GREEN = YaeltexTurnColorManager.getIndexFor(ColorEx.GREEN);
    public static final int DARK_GREEN = 51;
    public static final int BLUE = YaeltexTurnColorManager.getIndexFor(ColorEx.BLUE);
    public static final int DARK_BLUE = YaeltexTurnColorManager.getIndexFor(ColorEx.DARK_BLUE);
    public static final int YELLOW = YaeltexTurnColorManager.getIndexFor(ColorEx.YELLOW);
    public static final int DARK_YELLOW = YaeltexTurnColorManager.getIndexFor(ColorEx.DARK_YELLOW);
    public static final int ORANGE = 7;
    public static final int DARK_ORANGE = YaeltexTurnColorManager.getIndexFor(ColorEx.DARK_ORANGE);
    public static final int PINK = YaeltexTurnColorManager.getIndexFor(ColorEx.PINK);
    public static final int ROSE = 3;
    public static final int BROWN = 11;
    public static final int DARK_BROWN = YaeltexTurnColorManager.getIndexFor(ColorEx.DARK_BROWN);
    public static final int MINT = YaeltexTurnColorManager.getIndexFor(ColorEx.MINT);
    public static final int OLIVE = YaeltexTurnColorManager.getIndexFor(ColorEx.OLIVE);
    public static final int SKY_BLUE = YaeltexTurnColorManager.getIndexFor(ColorEx.SKY_BLUE);
    public static final int PURPLE = YaeltexTurnColorManager.getIndexFor(ColorEx.PURPLE);
    public static final int DARK_PURPLE = YaeltexTurnColorManager.getIndexFor(ColorEx.DARK_PURPLE);
    public static final int RED_WINE = 124;
    public static final int CYAN = YaeltexTurnColorManager.getIndexFor(ColorEx.CYAN);
    public static final String BUTTON_STATE_SHIFT = "BUTTON_STATE_SHIFT";
    public static final String BUTTON_STATE_SELECT = "BUTTON_STATE_SELECT";
    public static final String BUTTON_STATE_SESSION = "BUTTON_STATE_SESSION";
    public static final String BUTTON_STATE_TRACK = "BUTTON_STATE_TRACK";
    public static final String BUTTON_STATE_LAYER = "BUTTON_STATE_LAYER";
    public static final String BUTTON_STATE_PLAY = "BUTTON_STATE_PLAY";
    public static final String BUTTON_STATE_STOP = "BUTTON_STATE_STOP";
    public static final String BUTTON_STATE_REC = "BUTTON_STATE_REC";
    public static final String BUTTON_STATE_OVERDUB = "BUTTON_STATE_OVERDUB";
    public static final String BUTTON_STATE_LOOP = "BUTTON_STATE_LOOP";
    public static final String BUTTON_STATE_TAP_TEMPO = "BUTTON_STATE_TAP_TEMPO";
    public static final String BUTTON_STATE_ARROW = "BUTTON_STATE_ARROW";
    private final Map<NoteAttribute, Integer> noteParamColors = new EnumMap<NoteAttribute, Integer>(NoteAttribute.class);

    public YaeltexTurnColorManager(IHost host) {
        this.registerColorIndex("BUTTON_STATE_OFF", 0);
        this.registerColorIndex("BUTTON_STATE_ON", 0);
        this.registerColorIndex("BUTTON_STATE_HI", 127);
        this.registerColorIndex("BUTTON_COLOR_OFF", 0);
        this.registerColorIndex("COLOR_SELECTED_PLAY_SCENE", 127);
        this.registerColorIndex(BUTTON_STATE_SHIFT, 127);
        this.registerColorIndex(BUTTON_STATE_SELECT, 127);
        this.registerColorIndex(BUTTON_STATE_SESSION, 127);
        this.registerColorIndex(BUTTON_STATE_TRACK, PURPLE);
        this.registerColorIndex(BUTTON_STATE_LAYER, DARK_YELLOW);
        this.registerColorIndex(BUTTON_STATE_PLAY, GREEN);
        this.registerColorIndex(BUTTON_STATE_STOP, GRAY);
        this.registerColorIndex(BUTTON_STATE_REC, 1);
        this.registerColorIndex(BUTTON_STATE_OVERDUB, 7);
        this.registerColorIndex(BUTTON_STATE_LOOP, CYAN);
        this.registerColorIndex(BUTTON_STATE_TAP_TEMPO, 127);
        this.registerColorIndex(BUTTON_STATE_ARROW, BLUE);
        this.registerColorIndex("COLOR_STEP_HILITE_NO_CONTENT", GREEN);
        this.registerColorIndex("COLOR_STEP_HILITE_CONTENT", GREEN);
        this.registerColorIndex("COLOR_STEP_MUTED", 12);
        this.registerColorIndex("COLOR_STEP_MUTED_CONT", 12);
        this.registerColorIndex("COLOR_STEP_SELECTED", 127);
        this.registerColorIndex("COLOR_NO_CONTENT", 0);
        this.registerColorIndex("COLOR_NO_CONTENT_4", 0);
        this.registerColorIndex("COLOR_CONTENT", BLUE);
        this.registerColorIndex("COLOR_CONTENT_CONT", CYAN);
        this.registerColorIndex("COLOR_PAGE", 127);
        this.registerColorIndex("COLOR_ACTIVE_PAGE", GREEN);
        this.registerColorIndex("COLOR_SELECTED_PAGE", BLUE);
        this.registerColorIndex("COLOR_PAD_OFF", 0);
        this.registerColorIndex("COLOR_PAD_RECORD", 1);
        this.registerColorIndex("COLOR_PAD_PLAY", GREEN);
        this.registerColorIndex("COLOR_PAD_SELECTED", 127);
        this.registerColorIndex("COLOR_PAD_MUTED", 12);
        this.registerColorIndex("COLOR_PAD_HAS_CONTENT", YELLOW);
        this.registerColorIndex("COLOR_PAD_NO_CONTENT", 0);
        this.registerColorIndex("GRID_COLOR_OFF", 0);
        for (int i = 0; i < 128; ++i) {
            this.registerColor(i, COLOR_TABLE[i]);
        }
        for (DAWColor dAWColor : DAWColor.values()) {
            this.registerColorIndex(dAWColor, YaeltexTurnColorManager.getIndexFor(dAWColor.getColor()));
            String name = dAWColor.name();
            this.registerColor(this.getColorIndex(name), DAWColor.getColorEntry(name));
        }
        this.noteParamColors.put(NoteAttribute.PITCH, 127);
        this.noteParamColors.put(NoteAttribute.MUTE, MINT);
        this.noteParamColors.put(NoteAttribute.DURATION, 11);
        this.noteParamColors.put(NoteAttribute.VELOCITY, 1);
        this.noteParamColors.put(NoteAttribute.RELEASE_VELOCITY, CYAN);
        this.noteParamColors.put(NoteAttribute.VELOCITY_SPREAD, GREEN);
        this.noteParamColors.put(NoteAttribute.TRANSPOSE, 127);
        this.noteParamColors.put(NoteAttribute.GAIN, OLIVE);
        this.noteParamColors.put(NoteAttribute.PANNING, GRAY);
        this.noteParamColors.put(NoteAttribute.CHANCE, BLUE);
        this.noteParamColors.put(NoteAttribute.PRESSURE, YELLOW);
        this.noteParamColors.put(NoteAttribute.TIMBRE, 124);
        this.noteParamColors.put(NoteAttribute.OCCURRENCE, SKY_BLUE);
        this.noteParamColors.put(NoteAttribute.REPEAT, 7);
        this.noteParamColors.put(NoteAttribute.REPEAT_CURVE, 3);
        this.noteParamColors.put(NoteAttribute.REPEAT_VELOCITY_CURVE, PINK);
        this.noteParamColors.put(NoteAttribute.REPEAT_VELOCITY_END, PURPLE);
        for (Enum enum_ : NoteAttribute.values()) {
            if (host.supports((NoteAttribute)enum_)) continue;
            this.noteParamColors.put((NoteAttribute)enum_, 0);
        }
    }

    @Override
    public ColorEx getColor(int colorIndex, ButtonID buttonID) {
        ColorEx color;
        switch (buttonID) {
            case PLAY: {
                color = ColorEx.GREEN;
                break;
            }
            case SHIFT: 
            case SELECT: 
            case CLIP: 
            case SESSION: 
            case TAP_TEMPO: {
                color = ColorEx.WHITE;
                break;
            }
            case TRACK: {
                color = ColorEx.PURPLE;
                break;
            }
            case USER: {
                color = ColorEx.DARK_YELLOW;
                break;
            }
            case STOP: {
                color = ColorEx.GRAY;
                break;
            }
            case RECORD: {
                color = ColorEx.RED;
                break;
            }
            case OVERDUB: {
                color = ColorEx.ORANGE;
                break;
            }
            case LOOP: {
                color = ColorEx.CYAN;
                break;
            }
            case ARROW_DOWN: 
            case ARROW_UP: 
            case ARROW_LEFT: 
            case ARROW_RIGHT: {
                color = ColorEx.BLUE;
                break;
            }
            default: {
                return super.getColor(colorIndex, buttonID);
            }
        }
        return colorIndex < 128 ? color : ColorEx.evenDarker(color);
    }

    public static final int getIndexFor(ColorEx color) {
        return ColorEx.getClosestColorIndex(color, COLOR_TABLE);
    }

    public int getParamColor(NoteAttribute noteEditParameter) {
        return this.noteParamColors.get((Object)noteEditParameter);
    }
}

