/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.osc.module;

import de.mossgrabers.controller.osc.exception.IllegalParameterException;
import de.mossgrabers.controller.osc.exception.MissingCommandException;
import de.mossgrabers.controller.osc.exception.UnknownCommandException;
import de.mossgrabers.controller.osc.module.AbstractModule;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IArranger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IMixer;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.osc.IOpenSoundControlWriter;
import java.util.LinkedList;
import java.util.Locale;

public class LayoutModule
extends AbstractModule {
    public LayoutModule(IHost host, IModel model, IOpenSoundControlWriter writer) {
        super(host, model, writer);
    }

    @Override
    public String[] getSupportedCommands() {
        return new String[]{"layout", "panel", "arranger", "mixer"};
    }

    @Override
    public void execute(String command, LinkedList<String> path, Object value) throws IllegalParameterException, UnknownCommandException, MissingCommandException {
        block6 : switch (command) {
            case "layout": {
                this.model.getApplication().setPanelLayout(LayoutModule.toString(value).toUpperCase(Locale.US));
                break;
            }
            case "panel": {
                String subCommand = LayoutModule.getSubCommand(path);
                IApplication app = this.model.getApplication();
                switch (subCommand) {
                    case "noteEditor": {
                        app.toggleNoteEditor();
                        break block6;
                    }
                    case "automationEditor": {
                        app.toggleAutomationEditor();
                        break block6;
                    }
                    case "devices": {
                        app.toggleDevices();
                        break block6;
                    }
                    case "mixer": {
                        app.toggleMixer();
                        break block6;
                    }
                    case "fullscreen": {
                        app.toggleFullScreen();
                        break block6;
                    }
                }
                throw new UnknownCommandException(subCommand);
            }
            case "arranger": {
                String subCommand2 = LayoutModule.getSubCommand(path);
                IArranger arrange = this.model.getArranger();
                switch (subCommand2) {
                    case "cueMarkerVisibility": {
                        arrange.toggleCueMarkerVisibility();
                        break block6;
                    }
                    case "playbackFollow": {
                        arrange.togglePlaybackFollow();
                        break block6;
                    }
                    case "trackRowHeight": {
                        arrange.toggleTrackRowHeight();
                        break block6;
                    }
                    case "clipLauncherSectionVisibility": {
                        arrange.toggleClipLauncher();
                        break block6;
                    }
                    case "timeLineVisibility": {
                        arrange.toggleTimeLine();
                        break block6;
                    }
                    case "ioSectionVisibility": {
                        arrange.toggleIoSection();
                        break block6;
                    }
                    case "effectTracksVisibility": {
                        arrange.toggleEffectTracks();
                        break block6;
                    }
                }
                throw new UnknownCommandException(subCommand2);
            }
            case "mixer": {
                String subCommand3 = LayoutModule.getSubCommand(path);
                IMixer mix = this.model.getMixer();
                switch (subCommand3) {
                    case "clipLauncherSectionVisibility": {
                        mix.toggleClipLauncherSectionVisibility();
                        break block6;
                    }
                    case "crossFadeSectionVisibility": {
                        mix.toggleCrossFadeSectionVisibility();
                        break block6;
                    }
                    case "deviceSectionVisibility": {
                        mix.toggleDeviceSectionVisibility();
                        break block6;
                    }
                    case "sendsSectionVisibility": {
                        mix.toggleSendsSectionVisibility();
                        break block6;
                    }
                    case "ioSectionVisibility": {
                        mix.toggleIoSectionVisibility();
                        break block6;
                    }
                    case "meterSectionVisibility": {
                        mix.toggleMeterSectionVisibility();
                        break block6;
                    }
                }
                throw new UnknownCommandException(subCommand3);
            }
            default: {
                throw new UnknownCommandException(command);
            }
        }
    }

    @Override
    public void flush(boolean dump) {
        IApplication app = this.model.getApplication();
        this.writer.sendOSC("/layout", app.getPanelLayout().toLowerCase(Locale.US), dump);
        IArranger arrange = this.model.getArranger();
        this.writer.sendOSC("/arranger/cueMarkerVisibility", arrange.areCueMarkersVisible(), dump);
        this.writer.sendOSC("/arranger/playbackFollow", arrange.isPlaybackFollowEnabled(), dump);
        this.writer.sendOSC("/arranger/trackRowHeight", arrange.hasDoubleRowTrackHeight(), dump);
        this.writer.sendOSC("/arranger/clipLauncherSectionVisibility", arrange.isClipLauncherVisible(), dump);
        this.writer.sendOSC("/arranger/timeLineVisibility", arrange.isTimelineVisible(), dump);
        this.writer.sendOSC("/arranger/ioSectionVisibility", arrange.isIoSectionVisible(), dump);
        this.writer.sendOSC("/arranger/effectTracksVisibility", arrange.areEffectTracksVisible(), dump);
        IMixer mix = this.model.getMixer();
        this.writer.sendOSC("/mixer/clipLauncherSectionVisibility", mix.isClipLauncherSectionVisible(), dump);
        this.writer.sendOSC("/mixer/crossFadeSectionVisibility", mix.isCrossFadeSectionVisible(), dump);
        this.writer.sendOSC("/mixer/deviceSectionVisibility", mix.isDeviceSectionVisible(), dump);
        this.writer.sendOSC("/mixer/sendsSectionVisibility", mix.isSendSectionVisible(), dump);
        this.writer.sendOSC("/mixer/ioSectionVisibility", mix.isIoSectionVisible(), dump);
        this.writer.sendOSC("/mixer/meterSectionVisibility", mix.isMeterSectionVisible(), dump);
    }
}

