/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.definition;

import de.mossgrabers.controller.novation.launchpad.definition.AbstractLaunchpadDefinition;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.utils.Pair;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class LaunchpadMiniMkIIIControllerDefinition
extends AbstractLaunchpadDefinition {
    private static final UUID EXTENSION_ID = UUID.fromString("A17B269D-2641-452F-B5A2-81BBACDA0D17");
    private static final String SYSEX_HEADER = "F0 00 20 29 02 0D ";
    private static final Optional<String> BRIGHTNESS_SYSEX = Optional.of("F0 00 20 29 02 0D 08 %02X F7");

    public LaunchpadMiniMkIIIControllerDefinition() {
        super(EXTENSION_ID, "Launchpad Mini MkIII");
    }

    @Override
    public List<Pair<String[], String[]>> getMidiDiscoveryPairs(OperatingSystem os) {
        List<Pair<String[], String[]>> midiDiscoveryPairs = super.getMidiDiscoveryPairs(os);
        switch (os) {
            case WINDOWS: {
                midiDiscoveryPairs.addAll(this.createWindowsDeviceDiscoveryPairs("MIDIIN2 (%sLPMiniMK3 MIDI)", "MIDIOUT2 (%sLPMiniMK3 MIDI)"));
                break;
            }
            case LINUX: {
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair("Launchpad Mini MK3 MIDI 2", "Launchpad Mini MK3 MIDI 2"));
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair("Launchpad Mini MK3 LPMiniMK3 MI", "Launchpad Mini MK3 LPMiniMK3 MI"));
                break;
            }
            case MAC: 
            case MAC_ARM: {
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair("Launchpad Mini MK3 LPMiniMK3 MIDI Out", "Launchpad Mini MK3 LPMiniMK3 MIDI In"));
                break;
            }
        }
        return midiDiscoveryPairs;
    }

    @Override
    public String getSysExHeader() {
        return SYSEX_HEADER;
    }

    @Override
    public String getStandaloneModeCommand() {
        return "10 00";
    }

    @Override
    public String getProgramModeCommand() {
        return "0E 01";
    }

    @Override
    public Optional<String> getBrightnessSysex() {
        return BRIGHTNESS_SYSEX;
    }
}

