/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchcontrol.mode.buttons;

import de.mossgrabers.controller.novation.launchcontrol.LaunchControlXLConfiguration;
import de.mossgrabers.controller.novation.launchcontrol.controller.LaunchControlXLControlSurface;
import de.mossgrabers.controller.novation.launchcontrol.mode.buttons.XLDrumSequencerMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.main.XLBaseNoteEditMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.featuregroup.AbstractMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class XLLoopLengthMode
extends AbstractMode<LaunchControlXLControlSurface, LaunchControlXLConfiguration> {
    private static final int SEQUENCER_STEPS = 8;

    public XLLoopLengthMode(LaunchControlXLControlSurface surface, IModel model) {
        super("Set loop length", surface, model, true);
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (row != 0 || event != ButtonEvent.DOWN) {
            return;
        }
        INoteClip clip = this.getClip();
        int steps = clip.getEditPage() * 8 + index + 1;
        clip.setLoopLength((double)steps * Resolution.getValueAt(this.getResolution()));
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int index = buttonID.ordinal() - ButtonID.ROW2_1.ordinal();
        if (index < 0 || index >= 8) {
            return 12;
        }
        INoteClip clip = this.getClip();
        int numberOfActiveSteps = (int)Math.floor(clip.getLoopLength() / Resolution.getValueAt(this.getResolution()));
        if (index >= (numberOfActiveSteps -= clip.getEditPage() * 8)) {
            return 12;
        }
        return index == numberOfActiveSteps - 1 ? 63 : 30;
    }

    private INoteClip getClip() {
        return ((XLBaseNoteEditMode)((LaunchControlXLControlSurface)this.surface).getModeManager().get(Modes.DRUM_SEQUENCER)).getClip();
    }

    private int getResolution() {
        return ((XLDrumSequencerMode)((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager().get(Modes.DRUM_SEQUENCER)).getSelectedResolutionIndex();
    }
}

