/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3;

import de.mossgrabers.controller.ni.maschine.Maschine;
import de.mossgrabers.controller.ni.maschine.core.RibbonMode;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import de.mossgrabers.framework.scale.ScaleLayout;
import de.mossgrabers.framework.view.Views;
import java.util.List;

public class MaschineConfiguration
extends AbstractConfiguration {
    private static final Views[] PREFERRED_NOTE_VIEWS = new Views[]{Views.PLAY, Views.DRUM};
    public static final Integer RIBBON_MODE = 100;
    private final Maschine maschine;
    private RibbonMode ribbonMode = RibbonMode.PITCH_DOWN;
    private IEnumSetting ribbonModeSetting;

    public MaschineConfiguration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes, Maschine maschine) {
        super(host, valueChanger, arpeggiatorModes);
        this.maschine = maschine;
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        this.activateScaleSetting(documentSettings);
        this.activateScaleBaseSetting(documentSettings);
        this.activateScaleInScaleSetting(documentSettings);
        this.activateScaleLayoutSetting(documentSettings, ScaleLayout.SEQUENT_UP.getName());
        this.activateNoteRepeatSetting(documentSettings);
        this.activateRecordButtonSetting(globalSettings);
        this.activateShiftedRecordButtonSetting(globalSettings);
        this.activateBehaviourOnPauseSetting(globalSettings);
        this.activateAccentActiveSetting(globalSettings);
        this.activateAccentValueSetting(globalSettings);
        this.activateQuantizeAmountSetting(globalSettings);
        this.activateTurnOffScalePadsSetting(globalSettings);
        this.activateShowPlayedChordsSetting(globalSettings);
        this.activateStartupViewSetting(globalSettings, PREFERRED_NOTE_VIEWS);
        String[] ribbonModeNames = RibbonMode.getNames();
        this.ribbonModeSetting = globalSettings.getEnumSetting("Ribbon Mode", "Play and Sequence", ribbonModeNames, ribbonModeNames[0]);
        this.ribbonModeSetting.addValueObserver(value -> {
            this.ribbonMode = RibbonMode.lookupByName(value);
            this.notifyObservers(RIBBON_MODE);
        });
        this.isSettingActive.add(RIBBON_MODE);
        this.activateSelectClipOnLaunchSetting(globalSettings);
        this.activateActionForRecArmedPad(globalSettings);
        this.activateExcludeDeactivatedItemsSetting(globalSettings);
        this.activateNewClipLengthSetting(globalSettings);
        this.activateKnobSpeedSetting(globalSettings);
        int footswitches = this.maschine.getFootswitches();
        if (footswitches >= 2) {
            this.activateFootswitchSetting(globalSettings, 0, "Footswitch (Tip)");
            this.activateFootswitchSetting(globalSettings, 1, "Footswitch (Ring)");
            if (footswitches == 4) {
                this.activateFootswitchSetting(globalSettings, 2, "Footswitch 2 (Tip)");
                this.activateFootswitchSetting(globalSettings, 3, "Footswitch 2 (Ring)");
            }
        }
        this.activateConvertAftertouchSetting(globalSettings);
    }

    public void setRibbonMode(RibbonMode mode) {
        this.ribbonModeSetting.set(mode.getName());
    }

    public RibbonMode getRibbonMode() {
        return this.ribbonMode;
    }
}

