/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mkii.mode;

import de.mossgrabers.controller.ni.kontrol.mkii.KontrolProtocolConfiguration;
import de.mossgrabers.controller.ni.kontrol.mkii.controller.KontrolProtocolControlSurface;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.empty.EmptySend;
import de.mossgrabers.framework.mode.track.DefaultTrackMode;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.SendParameterProvider;
import java.util.List;
import java.util.Optional;

public class SendMode
extends DefaultTrackMode<KontrolProtocolControlSurface, KontrolProtocolConfiguration> {
    public SendMode(KontrolProtocolControlSurface surface, IModel model, List<ContinuousID> controls) {
        super("Send", surface, model, false);
        this.setControls(controls);
        SendParameterProvider pp = new SendParameterProvider(model, -1, 0);
        this.setParameterProvider(new CombinedParameterProvider(pp, pp));
        model.getTrackBank().addSelectionObserver((index, isSelected) -> this.parametersAdjusted());
    }

    @Override
    public void onKnobValue(int index, int value) {
        Optional track = this.model.getCurrentTrackBank().getSelectedItem();
        if (track.isEmpty()) {
            return;
        }
        ISend send = (ISend)((ITrack)track.get()).getSendBank().getItem(index);
        if (this.isAbsolute) {
            send.setValue(value);
        } else {
            send.changeValue(value);
        }
    }

    @Override
    public int getKnobValue(int index) {
        ISendBank sendBank;
        IValueChanger valueChanger = this.model.getValueChanger();
        Optional selectedTrack = this.bank.getSelectedItem();
        ISendBank iSendBank = sendBank = selectedTrack.isEmpty() ? null : ((ITrack)selectedTrack.get()).getSendBank();
        if (index >= 80 && index < 88) {
            ISend send = sendBank == null ? EmptySend.INSTANCE : (ISend)sendBank.getItem(index - 80);
            return valueChanger.toMidiValue(send.getValue());
        }
        if (index >= 88 && index < 96) {
            ISend send = sendBank == null ? EmptySend.INSTANCE : (ISend)sendBank.getItem(index - 88);
            return valueChanger.toMidiValue(send.getValue());
        }
        int scrollTracksState = (sendBank != null && sendBank.canScrollPageBackwards() ? 1 : 0) + (sendBank != null && sendBank.canScrollPageForwards() ? 2 : 0);
        boolean scrollScenesState = false;
        KontrolProtocolConfiguration configuration = (KontrolProtocolConfiguration)((KontrolProtocolControlSurface)this.surface).getConfiguration();
        switch (index) {
            case 49: {
                return scrollTracksState;
            }
            case 48: {
                return configuration.isFlipTrackClipNavigation() ? 0 : scrollTracksState;
            }
            case 50: {
                return configuration.isFlipTrackClipNavigation() ? scrollTracksState : 0;
            }
        }
        return 0;
    }

    @Override
    public void updateDisplay() {
        ((KontrolProtocolControlSurface)this.surface).sendGlobalValues(this.model);
        IValueChanger valueChanger = this.model.getValueChanger();
        Optional selectedTrack = this.bank.getSelectedItem();
        ISendBank sendBank = selectedTrack.isEmpty() ? null : ((ITrack)selectedTrack.get()).getSendBank();
        int[] vuData = new int[16];
        for (int i = 0; i < 8; ++i) {
            ISend send = sendBank == null ? EmptySend.INSTANCE : (ISend)sendBank.getItem(i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(64, send.doesExist() ? 5 : 0, i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(66, send.isSelected() ? 1 : 0, i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(69, 0, i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(70, 0, i, send.getDisplayedValue(8));
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(71, 0, i, send.getDisplayedValue(8));
            String n = selectedTrack.isPresent() ? this.getLabel((ITrack)selectedTrack.get(), send) : "";
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(72, 0, i, n);
            int j = 2 * i;
            vuData[j] = valueChanger.toMidiValue(send.getModulatedValue());
            vuData[j + 1] = valueChanger.toMidiValue(send.getModulatedValue());
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(67, 0, i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(68, 0, i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(74, 0, i);
            ((KontrolProtocolControlSurface)this.surface).sendCommand(104, 0);
            ((KontrolProtocolControlSurface)this.surface).sendCommand(105, 0);
        }
        ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(73, 2, 0, vuData);
    }

    @Override
    public void selectPreviousItem() {
        Optional selectedTrack = this.bank.getSelectedItem();
        if (selectedTrack.isPresent()) {
            ((ITrack)selectedTrack.get()).getSendBank().selectPreviousPage();
        }
    }

    @Override
    public void selectNextItem() {
        Optional selectedTrack = this.bank.getSelectedItem();
        if (selectedTrack.isPresent()) {
            ((ITrack)selectedTrack.get()).getSendBank().selectNextPage();
        }
    }

    @Override
    public void selectPreviousItemPage() {
        this.selectPreviousItem();
    }

    @Override
    public void selectNextItemPage() {
        this.selectNextItem();
    }

    private String getLabel(ITrack track, ISend send) {
        String name = send.doesExist() ? send.getName() : "None";
        switch (((KontrolProtocolControlSurface)this.surface).getProtocolVersion()) {
            case 1: {
                return "S" + (send.getPosition() + 1) + ": " + name;
            }
            case 2: {
                return "FX Track " + (track.getPosition() + 1) + (send.getPosition() + 1) + "\n" + name;
            }
        }
        return "S" + (send.getPosition() + 1) + ": " + name;
    }
}

